/* **********************************************************
 * Copyright 2014, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.core.abort;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;

/**
 * Async handle that supports request abort. The supplied {@link AbortHandle}
 * can be used to abort the request that uses this handle.
 */
public class AbortableAsyncHandle<T> extends DecoratorAsyncHandle<T> implements
        AbortHandleProvider {
    private final AbortHandle abortHandle;

    /**
     * Constructor.
     *
     * @param decorated the async handle that would be used to complete the
     *                  operation; must not be null.
     * @param handle    abort handle for the operation; must not be null.
     */
    public AbortableAsyncHandle(AsyncHandle<T> decorated, AbortHandle handle) {
        super(decorated);
        Validate.notNull(handle);
        this.abortHandle = handle;
    }

    @Override
    public AbortHandle getAbortHandle() {
        return abortHandle;
    }
}