/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.dsig.json;

/**
 * Implementation of this interface should be able to transform messages into
 * their canonical form
 */
public interface Canonicalizer {

    /**
     * Transforms the message into its canonical form
     *
     * @param message
     *            cannot be null
     * @return the canonical form of the message. Cannot be null.
     */
    String asCanonicalString(String message);
}
