/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;

/**
 * REST response body converter.
 */
public interface BodyConverter {
    /**
     * Extracts the VAPI result value from the specified {@link HttpResponse}. In
     * case <code>value</code> wrapper is used the wrapper is removed.
     *
     * @param serviceId
     * @param operationId
     * @param response the {@link HttpResponse}; must not be null.
     * @return proper VAPI result with removed wrapper if one is expected.
     */
    DataValue getResult(String serviceId,
                        String operationId,
                        HttpResponse response);
}
