/* **********************************************************
 * Copyright (c) 2015-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;

/**
 * Rest error converter interface. Implementations are responsible for
 * converting Rest errors to vAPI {@link ErrorValue}.
 */
public interface ErrorConverter {
    /**
     * Convert REST HTTP error to vAPI error.
     *
     * @param response the response that represents the error.
     * @return the converted error; must not be <code>null</code>.
     */
    ErrorValue getError(HttpResponse response);
}