/* **********************************************************
 * Copyright (c) 2015-2016, 2018-2019 VMware, Inc. All rights reserved. VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.util.Validate;

//TODO add unit tests, logging and exception handling.
/**
 * Implementation of {@link HttpRequest}.
 * <p>
 * <i>Thread-safety:</i> This class is not thread safe and thus instances of it
 * must not be shared across threads.
 */
public class HttpRequestImpl implements HttpRequest {
    private String url;
    private HttpMethod method;
    private Map<String, List<String>> headers = new HashMap<>();
    private byte[] body;
    private Integer readTimeout;

    @Override
    public String getUrl() {
        return url;
    }

    @Override
    public void setUrl(String url) {
        Validate.notNull(url);
        this.url = url;
    }

    @Override
    public HttpMethod getMethod() {
        return method;
    }

    @Override
    public void setMethod(HttpMethod method) {
        Validate.notNull(method);
        this.method = method;
    }

    @Override
    public byte[] getBody() {
        return body;
    }

    @Override
    public void setBody(byte[] body) {
        this.body = body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return headers;
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public void addHeader(String name,
                          String value) {
        Validate.notNull(name);
        Validate.notNull(value);
        Utils.addListEntryToMapOfLists(name, value, headers);
    }

    @Override
    public Integer getReadTimeout() {
       return readTimeout;
    }

    public void setReadTimeout(Integer value) {
       readTimeout = value;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(body);
        result = prime * result + ((headers == null) ? 0 : headers.hashCode());
        result = prime * result + ((method == null) ? 0 : method.hashCode());
        result = prime * result + ((url == null) ? 0 : url.hashCode());
        result = prime * result + ((readTimeout == null) ? 0 : readTimeout);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HttpRequestImpl other = (HttpRequestImpl) obj;
        if (!Arrays.equals(body, other.body))
            return false;
        if (headers == null) {
            if (other.headers != null)
                return false;
        } else if (!headers.equals(other.headers))
            return false;
        if (method != other.method)
            return false;
        if (url == null) {
            if (other.url != null)
                return false;
        } else if (!url.equals(other.url))
            return false;
        if (readTimeout == null) {
            if (other.readTimeout != null)
                return false;
        } else if (!readTimeout.equals(other.readTimeout))
            return false;
        return true;
    }
}
