/* **********************************************************
 * Copyright (c) 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http.adapter;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.routing.HttpRoutePlanner;

/**
 * Adapter interface supporting proxy configuration.
 */
public interface ProxyAwareHttpClientBuilderAdapter {

    /**
     * Assigns {@link HttpRoutePlanner} instance.
     */
    ProxyAwareHttpClientBuilderAdapter setRoutePlanner(final HttpRoutePlanner routePlanner);

    /**
     * Assigns default proxy value.
     * <p>
     * Please note this value can be overridden by the {@link #setRoutePlanner(
     *   org.apache.http.conn.routing.HttpRoutePlanner)} method.
     */
    ProxyAwareHttpClientBuilderAdapter setProxy(final HttpHost proxy);

    /**
     * Adds this protocol interceptor to the head of the protocol processing list.
     */
    ProxyAwareHttpClientBuilderAdapter addInterceptorFirst(final HttpRequestInterceptor itcp);
}