/* **********************************************************
 * Copyright (c) 2012, 2019 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.internal.protocol.common.json.JsonConstants.RequestType;

/**
 * Class to represent an INVOKE_METHOD JSON RPC 2.0 request.
 */
public final class JsonApiRequest {
    private final String id;
    private final JsonInvokeParams params;

    /**
     * @param id Identifier to be used in the JSON-RPC 2.0 request
     * @param params Arguments for the INVOKE request
     */
    public JsonApiRequest(String id,
                          JsonInvokeParams params) {
        this.id = id;
        this.params = params;
    }

    public String getJsonrpc() {
        return JsonConstants.JSON_RPC_VERSION;
    }

    public String getId() {
        return id;
    }

    public String getMethod() {
        return RequestType.invoke.toString();
    }

    public JsonInvokeParams getParams() {
        return params;
    }
}