/* **********************************************************
 * Copyright 2012-2015 VMware, Inc. All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.common.json;

public final class JsonInvalidMethodParamsException extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String id;

    /**
     * Constructor
     *
     * @param id ID of the JSON-RPC 2.0 message
     * @param message Message describing why method params
     *                are invalid
     */
    public JsonInvalidMethodParamsException(String id, String message) {
        super(message);
        this.id = id;
    }

    public String getId() {
        return id;
    }
}
