/* **********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.server.rpc.http.util;

/**
 * Commmon utilities to manage Strings
 */
public class StringUtil {

   private StringUtil() {
      // prevent instantiation
   }

   /**
    * Joins the elements of an array into a single string separated by
    * separator.
    *
    * @param array array of elements
    * @param separator separator used to separate elements in the result string
    * @return string with elements in array separated by separator
    */
   public static String join(Object[] array, String separator) {
      if (array == null) {
         return null;
      }
      if (separator == null) {
         separator = "";
      }

      StringBuffer buf = new StringBuffer();
      for (int i = 0; i < array.length; i++) {
         if (i > 0) {
            buf.append(separator);
         }
         if (array[i] != null) {
            buf.append(array[i]);
         }
      }
      return buf.toString();
   }
}
