/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.std.activation.impl;

import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.std.activation.impl.ActivationFilter;

/**
 * Abstraction of the in-memory activation registry for the use of
 * {@link ActivationFilter}.
 */
public interface ActivationRegistry {

    /**
     * Registers an activation.
     *
     * @param activationId activation identifier; must not be <code>null</code>
     * @param methodId identifier of the method whose activation is registered;
     *                 must not be <code>null</code>
     * @throws IllegalArgumentException if an argument is <code>null</code>
     * @throws IllegalStateException if there is already an activation with the
     *                               specified identifier
     */
    public void register(String activationId, MethodIdentifier methodId)
            throws IllegalArgumentException, IllegalStateException;

    /**
     * Unregisters an activation. Tolerates non-existing activations.
     *
     * @param activationId activation identifier; must not be <code>null</code>
     * @throws IllegalArgumentException if the activation id is missing
     */
    public void unregister(String activationId) throws IllegalArgumentException;
}
