/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.tracing.otel;

import com.vmware.vapi.internal.tracing.TracingScope;
import com.vmware.vapi.internal.util.Validate;

import io.opentelemetry.context.Scope;

/**
 * A {@link TracingScope} that wraps an OpenTelemetry {@link Scope}
 */
public class OtelTracingScope implements TracingScope {
    private final Scope scope;

    OtelTracingScope(Scope scope) {
        Validate.notNull(scope);
        this.scope = scope;
    }

    @Override
    public void close() {
        scope.close();
    }
}
