/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureUtil {

    private static final Logger logger = LoggerFactory.getLogger(CompletableFutureUtil.class);

    private CompletableFutureUtil() {}

    // Replace with CompletableFuture.failedFuture from Java 9+
    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture<T> f = new CompletableFuture<>();
        f.completeExceptionally(t);
        return f;
    }

    // TODO: use in JwtAuthnHandler and RetryOnInvalidSignatureJwtAuthnHandler
    public static <T> CompletionStage<T> safeSupply(Supplier<CompletionStage<T>> supplier) {
        Objects.requireNonNull(supplier);
        CompletionStage<T> future;
        try {
            future = supplier.get();
        } catch (RuntimeException ex) {
            return failedFuture(ex);
        }
        if (future == null) {
            logger.error("Supplier {} returned null future", supplier);
            return failedFuture(new IllegalStateException("Supplier " + supplier + " returned null future"));
        }
        return future;
    }

}
