/* **********************************************************
 * Copyright (c) 2012-2013, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Utility methods that operate on java.io classes.
 */
public class IoUtil {

    private static final Logger logger =
            LoggerFactory.getLogger(IoUtil.class);

    private static final int COPY_BUFFER_SIZE = 1024;

    private IoUtil() {
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        byte[] buffer = new byte[COPY_BUFFER_SIZE];
        int len;
        while ((len = src.read(buffer)) >= 0) {
            dst.write(buffer, 0, len);
        }
    }

    public static byte[] readAll(InputStream inp) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        copy(inp, out);
        return out.toByteArray();
    }

    public static void silentClose(AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        } catch (Exception ex) {
            logger.debug("Error while closing resource", ex);
        }
    }
}
