/* **********************************************************
 * Copyright 2013, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * SingleBundleProvider.java --
 *
 *      Simple implementation of ResourceBundleProvider
 */
package com.vmware.vapi.l10n;

import java.util.Locale;
import java.util.ResourceBundle;

import com.vmware.vapi.internal.util.Validate;

/**
 * Simple implementation of {@link ResourceBundleProvider} based on
 * {@link ResourceBundle#getBundle(String)}.
 *
 * <p>Always resolve to the same family of resource bundles, based on the
 * specified <code>basename</code>.
 */
public class SimpleBundleProvider implements ResourceBundleProvider {

    private String baseName;
    public SimpleBundleProvider(String baseName) {
        Validate.notNull(baseName);
        this.baseName = baseName;
    }

    @Override
    public ResourceBundle getResourceBundle(String msgId, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale);
    }
}
