/* **********************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol;

public final class Constants {

    /**
     * The name of system property for enabling raw request and raw response
     * logging in java vapi runtime.
     */
    public static final String RAW_REQUEST_LOGGING_SYS_PROP =
            "com.vmware.vapi.runtime.log.raw.request";

    public static boolean shouldLogRawRequestResponse() {
        String rawLogging =
                System.getProperty(RAW_REQUEST_LOGGING_SYS_PROP);
        if (Boolean.valueOf(rawLogging)) {
            return true;
        } else {
            return false;
        }
    }

}
