/* **********************************************************
 * Copyright (c) 2015-2016, 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.client.http;

import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;

/**
 * Response post-processor. Implementation of this interface can modify the
 * response of REST operation invocation before using it for finishing the
 * operation invocation.
 */
public interface ResponsePostProcessor {

    /**
     * Post-process {@link MethodResult} before using it to complete operation invocation.
     * <p>
     * Exceptions thrown from this method will be ignored.
     *
     * @param serviceId service identifier
     * @param operationId operation identifier
     * @param result   request
     * @param response {@link HttpResponse} of the REST invocation
     * @return processed {@link DataValue}.
     */
    // TODO: the .internal HttpRequest is exposed in the public surface here
    //       https://bugzilla.eng.vmware.com/show_bug.cgi?id=2124336
    //
    //       Also we have two classes with simple name HttpResponse now - rename
    //       the .internal one
    MethodResult handle(String serviceId,
                        String operationId,
                        MethodResult result,
                        HttpResponse response);
}
