package com.vmware.vapi.protocol.server.rpc.http;

import java.util.Map;

public interface Filter {
   enum Dispatcher {
      REQUEST,
      FORWARD,
      INCLUDE,
//      ERROR
   }

   /**
    * @return the dispatchers
    */
   Dispatcher[] getDispatchers();

   /**
    * @param dispatchers should not have duplicates and nulls.
    */
   void setDispatchers(Dispatcher[] dispatchers);

   /**
    * Get the path for, which the filter is triggered.
    *
    * @return a standard servlet mapping pattern.
    */
   String getPath();

   /**
    * Set the path for which the filter is triggered.
    * <p>
    * The path must follow the standard Servlet spec mapping patterns:
    * <ul>
    * <li><b>Exact</b>: starts with "/" and does not end with "/*".</li>
    * <li><b>Prefix</b>: starts with "/" and ends with "/*".</li>
    * <li><b>Extension</b>: starts with "*."</li>
    * <li><b>Default</b>: equals "/".</li>
    * </ul>
    * <p>
    * Request paths are tested against the mapping patterns in the standard
    * order:
    * <ol>
    * <li><b>Exact match</b>: E.g. "/foo".</li>
    * <li><b>Longest prefix match</b>: E.g. "/foo/bar/*" is tested before
    * "/foo/*".</li>
    * <li><b>Longest extension match</b>: E.g. "*.html" is tested before
    * "*.htm".</li>
    * <li><b>Default always matches</b>: E.g. use this if no other matches.</li>
    * </ol>
    * <p>
    *
    * @param path the path
    */
   void setPath(String path);

   /**
    * Get the Servlet API filter.
    *
    * @return a {@link javax.servlet.Filter} object.
    */
   javax.servlet.Filter getFilter();

   /**
    * Set the Servlet API Filter.
    *
    * @param filter the {@link javax.servlet.Filter}.
    */
   void setFilter(javax.servlet.Filter filter);

   /**
    * Get the parameters, which which the Filter will be initialized.
    *
    * @return a Map with the initial parameters or <code>null</code> if no
    *         initial configuration is set.
    */
   Map<String, String> getInitParameters();

   /**
    * Set the initial configuration of the Filter. These parameters will be
    * accessible to the Filter via it's {@link javax.servlet.FilterConfig}.
    *
    * @param params the parameters.
    */
   void setInitParameters(Map<String, String> params);
}
