/* **********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.server.rpc.http;

/**
 * Allow applications to add custom configuration to a @{link Server}
 * implementation before starting the server (e.g. spring configuration,
 * listeners, servlets, filters ...)
 */
public interface ServerConfigurator {

   /**
    * Customizes configuration for the server.
    * @param server The server being configured.
    */
   public void configure(Server server);
}
