/* **********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.server.rpc.http;

import java.io.IOException;

import org.springframework.core.io.Resource;

/**
 * A <tt>Service</tt> for serving static content/files. Instances should be
 * registered in the usual way using {@link Server#setServices}.
 */
public interface StaticContentService extends Service {

   /**
    * Set the static content base.
    * @param contentBase {@link Resource} representing the static
    *            content base; should be backed by a file
    *
    * @throws IOException if the resource cannot be resolved as absolute
    *    file path (not available in a file system)
    */
   void setContentBase(Resource contentBase) throws IOException;

   /**
    * Get the static content base.
    * @return <tt>Resource</tt> representing the content base
    */
   Resource getContentBase();

   /**
    * Get static content base as absolute path.
    * @return <tt>String</tt> representing the path
    */
   String getContentBasePath();

   /**
    * @param dirListing true to enable directory listing.
    */
   void setDirListing(boolean dirListing);

   /**
    * @return true if directory listing is enabled
    */
   boolean getDirListing();
}
