/* **********************************************************
 * Copyright 2012-2013 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * HttpServer.java --
 *
 *      Implementation of the HTTP server rpc layer.
 */
package com.vmware.vapi.protocol.server.rpc.http.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vapi.protocol.ProtocolHandler;
import com.vmware.vapi.protocol.server.rpc.http.Server;

/**
 * The server side of the HTTP protocol handler. Loads HTTP server configuration
 * and provides start/stop capability.
 */
public final class HttpServer implements ProtocolHandler {
    private final static Logger logger =
            LoggerFactory.getLogger(HttpServer.class);

    private final Server server;

    public HttpServer(Server server) {
        this.server = server;
    }

    /**
     * Method to start HTTP server.
     *
     * @param provider  required; ApiProvider that will process all incoming
     *                  requests
     * @throws IllegalArgumentException  if {@code provider} is {@code null}
     */
    @Override
    public void start() {
        try {
            server.start();
        } catch (Exception e) {
            logger.error(
                    "Caught exception during start of Http server", e);
        }
    }

    /**
     * Method to stop HTTP server
     */
    @Override
    public void stop() {
        logger.debug("Stopping HttpServer");
        try {
            server.stop();
        } catch (Exception e) {
            logger.error("Caught exception while trying to stop Http server", e);
        }
    }

}
