/* **********************************************************
 * Copyright 2011 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * ServerInterface.java --
 *
 *      Starts an ApiProvider server.
 */

package com.vmware.vapi.server;

import java.util.*;
import java.util.concurrent.*;

import com.vmware.vapi.core.*;
import com.vmware.vapi.protocol.*;

/**
 * Interface for an ApiProvider server.
 */
public interface ServerInterface extends Runnable {

    /** Stops the server. */
    public void stop();

    /**
     * Wait for the server shutdown to complete. If the server is already
     * shutdown, the method will return <code>true</code> immediately.
     *
     * @param timeoutMillis     maximum time to wait for the shutdown to
     *                          complete (in milliseconds)
     * @return                  whether the shutdown completed or the timeout
     *                          expired
     * @throws InterruptedException the wait has been interrupted
     */
    public boolean waitForShutdown(long timeoutMillis)
            throws InterruptedException;

    /** Runs the server. */
    public void run();

    /**
     * Returns local connection to the primary API provider. This connection can
     * be used only by clients inside the same process.
     *
     * @return connection which involves no networking
     */
    public ProtocolConnection getLocalConnection();
}
