/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std;

/**
 * The {@code LocalizableMessage} class represents localizable string and message
 * template. Interfaces include one or more localizable message templates in the
 * exceptions they report so that clients can display diagnostic messages in the
 * native language of the user. Interfaces can include localizable strings in the
 * data returned from methods to allow clients to display localized status
 * information in the native language of the user.
 */
public final class LocalizableMessage implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String id;

    private java.lang.String defaultMessage;

    private java.util.List<java.lang.String> args;

    private java.util.Map<java.lang.String, com.vmware.vapi.std.LocalizationParam> params;

    private java.lang.String localized;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public LocalizableMessage(java.lang.String id, java.lang.String defaultMessage, java.util.List<java.lang.String> args) {
        this();
        this.id = id;
        this.defaultMessage = defaultMessage;
        this.args = args;
    }

    /**
     * Default constructor.
     */
    public LocalizableMessage() {
    }

    protected LocalizableMessage(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Unique identifier of the localizable string or message template. 
     * <p> This
     * identifier is typically used to retrieve a locale-specific string or message
     * template from a message catalog.</p>
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of the localizable string or message template. 
     * <p> This
     * identifier is typically used to retrieve a locale-specific string or message
     * template from a message catalog.</p>
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The value of this localizable string or message template in the {@code en_US}
     * (English) locale. If {@link com.vmware.vapi.std.LocalizableMessage#getId} refers
     * to a message template, the default message will contain the substituted
     * arguments. This value can be used by clients that do not need to display strings
     * and messages in the native language of the user. It could also be used as a
     * fallback if a client is unable to access the appropriate message catalog.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultMessage() {
        return this.defaultMessage;
    }

    /**
     * The value of this localizable string or message template in the {@code en_US}
     * (English) locale. If {@link com.vmware.vapi.std.LocalizableMessage#getId} refers
     * to a message template, the default message will contain the substituted
     * arguments. This value can be used by clients that do not need to display strings
     * and messages in the native language of the user. It could also be used as a
     * fallback if a client is unable to access the appropriate message catalog.
     *
     * @param defaultMessage New value for the property.
     */
    public void setDefaultMessage(java.lang.String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    /**
     * Positional arguments to be substituted into the message template. This list will
     * be empty if the message uses named arguments or has no arguments.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getArgs() {
        return this.args;
    }

    /**
     * Positional arguments to be substituted into the message template. This list will
     * be empty if the message uses named arguments or has no arguments.
     *
     * @param args New value for the property.
     */
    public void setArgs(java.util.List<java.lang.String> args) {
        this.args = args;
    }

    /**
     * Named arguments to be substituted into the message template.
     *
     * {@code null} means that the message template requires no arguments or positional
     * arguments are used.
     *
     * @return The current value of the property.
     */
    public java.util.Map<java.lang.String, com.vmware.vapi.std.LocalizationParam> getParams() {
        return this.params;
    }

    /**
     * Named arguments to be substituted into the message template.
     *
     * {@code null} means that the message template requires no arguments or positional
     * arguments are used.
     *
     * @param params New value for the property.
     */
    public void setParams(java.util.Map<java.lang.String, com.vmware.vapi.std.LocalizationParam> params) {
        this.params = params;
    }

    /**
     * Localized string value as per request requirements.
     *
     * when the client has not requested specific locale the implementation may not
     * populate this field to conserve resources.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalized() {
        return this.localized;
    }

    /**
     * Localized string value as per request requirements.
     *
     * when the client has not requested specific locale the implementation may not
     * populate this field to conserve resources.
     *
     * @param localized New value for the property.
     */
    public void setLocalized(java.lang.String localized) {
        this.localized = localized;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.vapi.std.StructDefinitions.localizableMessage;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("default_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultMessage, this._getType().getField("default_message")));
        structValue.setField("args",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.args, this._getType().getField("args")));
        structValue.setField("params",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.params, this._getType().getField("params")));
        structValue.setField("localized",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localized, this._getType().getField("localized")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.vapi.std.StructDefinitions.localizableMessage;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.StructDefinitions.localizableMessage.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LocalizableMessage _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LocalizableMessage(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LocalizableMessage _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LocalizableMessage(structValue);
    }

    /**
     * Builder class for {@link LocalizableMessage}.
     */
    public static final class Builder {
        private java.lang.String id;
        private java.lang.String defaultMessage;
        private java.util.List<java.lang.String> args;
        private java.util.Map<java.lang.String, com.vmware.vapi.std.LocalizationParam> params;
        private java.lang.String localized;

        /**
         * Constructor with parameters for the required properties of
         * {@link LocalizableMessage}.
         */
        public Builder(java.lang.String id, java.lang.String defaultMessage, java.util.List<java.lang.String> args) {
            this.id = id;
            this.defaultMessage = defaultMessage;
            this.args = args;
        }

        /**
         * Named arguments to be substituted into the message template.
         *
         * {@code null} means that the message template requires no arguments or positional
         * arguments are used.
         *
         * @param params New value for the property.
         */
        public Builder setParams(java.util.Map<java.lang.String, com.vmware.vapi.std.LocalizationParam> params) {
            this.params = params;
            return this;
        }

        /**
         * Localized string value as per request requirements.
         *
         * when the client has not requested specific locale the implementation may not
         * populate this field to conserve resources.
         *
         * @param localized New value for the property.
         */
        public Builder setLocalized(java.lang.String localized) {
            this.localized = localized;
            return this;
        }

        public LocalizableMessage build() {
            LocalizableMessage result = new LocalizableMessage();
            result.setId(this.id);
            result.setDefaultMessage(this.defaultMessage);
            result.setArgs(this.args);
            result.setParams(this.params);
            result.setLocalized(this.localized);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("id", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_message", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_message",
                                                                                "defaultMessage",
                                                                                "getDefaultMessage",
                                                                                "setDefaultMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("args", new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("args",
                                                                                "args",
                                                                                "getArgs",
                                                                                "setArgs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("params", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.MapType(new com.vmware.vapi.bindings.type.StringType(), new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.StructDefinitions.localizationParam; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("params",
                                                                                "params",
                                                                                "getParams",
                                                                                "setParams");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("localized", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("localized",
                                                                                "localized",
                                                                                "getLocalized",
                                                                                "setLocalized");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.localizable_message",
                                                            fields,
                                                            com.vmware.vapi.std.LocalizableMessage.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

