/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 */

package com.vmware.vapi.std.introspection;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.introspection.ServiceProvider} interface).
 *
 * <p>This adapter expects asynchronous/non-blocking API service implementation.</p>
 */
public class ServiceApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.introspection.ServiceProvider impl;

    private class ListApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public ListApiMethod() {
            super(ServiceApiInterface.this.getIdentifier(),
                  "list",
                  com.vmware.vapi.std.introspection.ServiceDefinitions.__listInput,
                  com.vmware.vapi.std.introspection.ServiceDefinitions.__listOutput,
                  getTypeConverter(),
                  null,
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            impl.list(new com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl<java.util.Set<java.lang.String>>(getTypeConverter(),com.vmware.vapi.std.introspection.ServiceDefinitions.__listOutput, invocationContext, asyncHandle, this));
        }
    }

    private class GetApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public GetApiMethod() {
            super(ServiceApiInterface.this.getIdentifier(),
                  "get",
                  com.vmware.vapi.std.introspection.ServiceDefinitions.__getInput,
                  com.vmware.vapi.std.introspection.ServiceDefinitions.__getOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.introspection.ServiceDefinitions.__getInput,
                                                                               getTypeConverter());
            java.lang.String id = extr.<java.lang.String>valueForField("id");
            impl.get(id, new com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl<com.vmware.vapi.std.introspection.ServiceTypes.Info>(getTypeConverter(),com.vmware.vapi.std.introspection.ServiceDefinitions.__getOutput, invocationContext, asyncHandle, this));
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.introspection.impl.ServiceImpl} class. This
     * class will be loaded and instantiated.
     */
    public ServiceApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.introspection.ServiceProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.introspection.ServiceProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #ServiceApiInterface()}.
     */
    public ServiceApiInterface(java.lang.Class<? extends com.vmware.vapi.std.introspection.ServiceProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.introspection.impl.ServiceImpl",
                                com.vmware.vapi.std.introspection.ServiceProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ServiceProvider}
     *             API service. Must not be {@code null}.
     */
    public ServiceApiInterface(com.vmware.vapi.std.introspection.ServiceProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ServiceProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public ServiceApiInterface(com.vmware.vapi.std.introspection.ServiceProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.service", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new ListApiMethod());
        registerMethod(new GetApiMethod());
    }
}
