/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for model: com.vmware.vapi.
 */

package com.vmware.vapi.util;

import java.util.Map;

import com.vmware.vapi.internal.util.Validate;

import com.vmware.vapi.bindings.type.StructType;

/**
 * Utility for StructType.
 */
public final class StructTypeUtil {

    /**
     * Populates mappings for structures defined in a model (set of VMODL
     * definitions).
     *
     * For each top level structure and each structure defined in a service,
     * adds an entry to the map where the key is the fully qualified canonical
     * name of the structure, and the value is a StructType. It allows to
     * retrieve the StructType from the canonical name of an structure.
     *
     * @param mapping map to fill with mappings for each structure in the bindings;
     *                must not be null.
     */
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        add(mapping,
            "com.vmware.vapi.std.authentication_scheme",
            com.vmware.vapi.std.StructDefinitions.authenticationScheme);
        add(mapping,
            "com.vmware.vapi.std.dynamic_ID",
            com.vmware.vapi.std.StructDefinitions.dynamicID);
        add(mapping,
            "com.vmware.vapi.std.localizable_message",
            com.vmware.vapi.std.StructDefinitions.localizableMessage);
        add(mapping,
            "com.vmware.vapi.std.localization_param",
            com.vmware.vapi.std.StructDefinitions.localizationParam);
        add(mapping,
            "com.vmware.vapi.std.nested_localizable_message",
            com.vmware.vapi.std.StructDefinitions.nestedLocalizableMessage);
        add(mapping,
            "com.vmware.vapi.std.errors.already_exists",
            com.vmware.vapi.std.errors.StructDefinitions.alreadyExists);
        add(mapping,
            "com.vmware.vapi.std.errors.already_in_desired_state",
            com.vmware.vapi.std.errors.StructDefinitions.alreadyInDesiredState);
        add(mapping,
            "com.vmware.vapi.std.errors.argument_locations",
            com.vmware.vapi.std.errors.StructDefinitions.argumentLocations);
        add(mapping,
            "com.vmware.vapi.std.errors.canceled",
            com.vmware.vapi.std.errors.StructDefinitions.canceled);
        add(mapping,
            "com.vmware.vapi.std.errors.concurrent_change",
            com.vmware.vapi.std.errors.StructDefinitions.concurrentChange);
        add(mapping,
            "com.vmware.vapi.std.errors.error",
            com.vmware.vapi.std.errors.StructDefinitions.error);
        add(mapping,
            "com.vmware.vapi.std.errors.feature_in_use",
            com.vmware.vapi.std.errors.StructDefinitions.featureInUse);
        add(mapping,
            "com.vmware.vapi.std.errors.file_locations",
            com.vmware.vapi.std.errors.StructDefinitions.fileLocations);
        add(mapping,
            "com.vmware.vapi.std.errors.internal_server_error",
            com.vmware.vapi.std.errors.StructDefinitions.internalServerError);
        add(mapping,
            "com.vmware.vapi.std.errors.invalid_argument",
            com.vmware.vapi.std.errors.StructDefinitions.invalidArgument);
        add(mapping,
            "com.vmware.vapi.std.errors.invalid_element_configuration",
            com.vmware.vapi.std.errors.StructDefinitions.invalidElementConfiguration);
        add(mapping,
            "com.vmware.vapi.std.errors.invalid_element_type",
            com.vmware.vapi.std.errors.StructDefinitions.invalidElementType);
        add(mapping,
            "com.vmware.vapi.std.errors.invalid_request",
            com.vmware.vapi.std.errors.StructDefinitions.invalidRequest);
        add(mapping,
            "com.vmware.vapi.std.errors.not_allowed_in_current_state",
            com.vmware.vapi.std.errors.StructDefinitions.notAllowedInCurrentState);
        add(mapping,
            "com.vmware.vapi.std.errors.not_found",
            com.vmware.vapi.std.errors.StructDefinitions.notFound);
        add(mapping,
            "com.vmware.vapi.std.errors.operation_not_found",
            com.vmware.vapi.std.errors.StructDefinitions.operationNotFound);
        add(mapping,
            "com.vmware.vapi.std.errors.resource_busy",
            com.vmware.vapi.std.errors.StructDefinitions.resourceBusy);
        add(mapping,
            "com.vmware.vapi.std.errors.resource_in_use",
            com.vmware.vapi.std.errors.StructDefinitions.resourceInUse);
        add(mapping,
            "com.vmware.vapi.std.errors.resource_inaccessible",
            com.vmware.vapi.std.errors.StructDefinitions.resourceInaccessible);
        add(mapping,
            "com.vmware.vapi.std.errors.service_unavailable",
            com.vmware.vapi.std.errors.StructDefinitions.serviceUnavailable);
        add(mapping,
            "com.vmware.vapi.std.errors.timed_out",
            com.vmware.vapi.std.errors.StructDefinitions.timedOut);
        add(mapping,
            "com.vmware.vapi.std.errors.transient_indication",
            com.vmware.vapi.std.errors.StructDefinitions.transientIndication);
        add(mapping,
            "com.vmware.vapi.std.errors.unable_to_allocate_resource",
            com.vmware.vapi.std.errors.StructDefinitions.unableToAllocateResource);
        add(mapping,
            "com.vmware.vapi.std.errors.unauthenticated",
            com.vmware.vapi.std.errors.StructDefinitions.unauthenticated);
        add(mapping,
            "com.vmware.vapi.std.errors.unauthorized",
            com.vmware.vapi.std.errors.StructDefinitions.unauthorized);
        add(mapping,
            "com.vmware.vapi.std.errors.unexpected_input",
            com.vmware.vapi.std.errors.StructDefinitions.unexpectedInput);
        add(mapping,
            "com.vmware.vapi.std.errors.unsupported",
            com.vmware.vapi.std.errors.StructDefinitions.unsupported);
        add(mapping,
            "com.vmware.vapi.std.errors.unverified_peer",
            com.vmware.vapi.std.errors.StructDefinitions.unverifiedPeer);
        add(mapping,
            "com.vmware.vapi.std.interposition.invocation_request",
            com.vmware.vapi.std.interposition.StructDefinitions.invocationRequest);
        add(mapping,
            "com.vmware.vapi.std.interposition.invocation_result",
            com.vmware.vapi.std.interposition.StructDefinitions.invocationResult);
        add(mapping,
            "com.vmware.vapi.std.interposition.security_principal",
            com.vmware.vapi.std.interposition.StructDefinitions.securityPrincipal);
        add(mapping,
            "com.vmware.vapi.std.introspection.operation.data_definition",
            com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition);
        add(mapping,
            "com.vmware.vapi.std.introspection.operation.info",
            com.vmware.vapi.std.introspection.OperationDefinitions.info);
        add(mapping,
            "com.vmware.vapi.std.introspection.provider.info",
            com.vmware.vapi.std.introspection.ProviderDefinitions.info);
        add(mapping,
            "com.vmware.vapi.std.introspection.service.info",
            com.vmware.vapi.std.introspection.ServiceDefinitions.info);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key +
                                               ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}
