/* **********************************************************
 * Copyright 2012-2014, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.util.async;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.util.Validate;

/**
 * Utility which decorates an existing async handle. Use as a base class and
 * override just the methods you need to save some boilerplate.
 *
 * @param <T> result type of the async handle
 */
public class DecoratorAsyncHandle<T> extends AsyncHandle<T> {

    protected final AsyncHandle<T> decorated;

    /**
     * Creates a decorator around the specified handle.
     *
     * @param decorated handle to be decorated; must not be null.
     */
    public DecoratorAsyncHandle(AsyncHandle<T> decorated) {
        Validate.notNull(decorated);
        this.decorated = decorated;
    }

    @Override
    public void updateProgress(DataValue progress) {
        decorated.updateProgress(progress);
    }

    @Override
    public void setResult(T result) {
        decorated.setResult(result);
    }

    @Override
    public void setError(RuntimeException error) {
        decorated.setError(error);
    }

}
