/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ValueVisitor;
import java.util.Arrays;

public final class BlobValue
implements DataValue {
    private static final long serialVersionUID = 1L;
    private final byte[] value;

    public BlobValue(byte[] value) {
        if (value == null) {
            throw new CoreException(MessageFactory.getMessage("vapi.data.blob.null.bytearray", new String[0]));
        }
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.BLOB;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof BlobValue) {
            BlobValue blob = (BlobValue)o;
            return Arrays.equals(this.value, blob.value);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return "<array of " + this.value.length + " bytes>";
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BlobValue copy() {
        return new BlobValue(Arrays.copyOf(this.value, this.value.length));
    }
}

