/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRequestConfigurationMerger;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpResponse;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.util.Validate;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientRestTransport
implements RestTransport {
    private static final Logger logger = LoggerFactory.getLogger(ApacheClientRestTransport.class);
    private final CloseableHttpClient httpClient;
    private final ApacheClientRequestConfigurationMerger configMerger;
    private final ConnectionMonitor.CleanableConnectionPool connectionPool;

    public ApacheClientRestTransport(CloseableHttpClient httpClient) {
        this(httpClient, null);
    }

    public ApacheClientRestTransport(CloseableHttpClient httpClient, RequestConfig defaultRequestConfig) {
        this(httpClient, defaultRequestConfig, null);
    }

    public ApacheClientRestTransport(CloseableHttpClient httpClient, RequestConfig defaultRequestConfig, ConnectionMonitor.CleanableConnectionPool connectionPool) {
        this.httpClient = httpClient;
        this.configMerger = new ApacheClientRequestConfigurationMerger(defaultRequestConfig);
        this.connectionPool = connectionPool;
    }

    @Override
    public void execute(HttpRequest request, HttpRequest.HttpResponseHandler responseHandler, ExecutionContext ctx) {
        Validate.notNull(request.getUrl(), "Url of request is null. Cannot execute it.");
        Validate.notNull((Object)request.getMethod(), "Method of request is null. Cannot execute it.");
        HttpUriRequest apacheRequest = ApacheClientRestTransport.createRequest(request);
        ApacheClientRestTransport.addRequestHeaders(request, apacheRequest);
        ApacheClientRestTransport.addRequestBody(request, apacheRequest);
        HttpClientContext context = ApacheHttpUtil.createHttpContext(request.getReadTimeout(), this.configMerger);
        try {
            CloseableHttpResponse apacheResponse = this.httpClient.execute(apacheRequest, (HttpContext)context);
            ApacheHttpResponse response = new ApacheHttpResponse((HttpResponse)apacheResponse);
            ApacheClientRestTransport.handleResponseAccessors(response, ctx);
            responseHandler.onResult(response);
        }
        catch (Exception e) {
            responseHandler.onError(ApacheHttpClientExceptionTranslator.translate(e, null));
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    static HttpUriRequest createRequest(HttpRequest request) {
        switch (request.getMethod()) {
            case GET: {
                return new HttpGet(request.getUrl());
            }
            case HEAD: {
                return new HttpHead(request.getUrl());
            }
            case POST: {
                return new HttpPost(request.getUrl());
            }
            case PUT: {
                return new HttpPut(request.getUrl());
            }
            case DELETE: {
                return new HttpDelete(request.getUrl());
            }
            case OPTIONS: {
                return new HttpOptions(request.getUrl());
            }
            case PATCH: {
                return new HttpPatch(request.getUrl());
            }
        }
        IllegalArgumentException e = new IllegalArgumentException("Unsupported HTTP method requested: " + (Object)((Object)request.getMethod()));
        logger.error(e.getMessage(), (Throwable)e);
        throw e;
    }

    static void addRequestHeaders(HttpRequest request, HttpUriRequest apacheRequest) {
        for (Map.Entry<String, List<String>> headersForName : request.getHeaders().entrySet()) {
            for (String value : headersForName.getValue()) {
                BasicHeader header = new BasicHeader(headersForName.getKey(), value);
                apacheRequest.addHeader((Header)header);
            }
        }
    }

    static void addRequestBody(HttpRequest request, HttpUriRequest apacheRequest) {
        if (apacheRequest instanceof HttpEntityEnclosingRequest && request.getBody() != null) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)apacheRequest;
            ByteArrayEntity requestEntity = new ByteArrayEntity(request.getBody());
            entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
        }
    }

    static void handleResponseAccessors(ApacheHttpResponse response, ExecutionContext ctx) {
        ExecutionContext.RuntimeData runtimeData = ctx.retrieveRuntimeData();
        if (runtimeData == null || runtimeData.getResponseAccessor() == null) {
            return;
        }
        try {
            runtimeData.getResponseAccessor().access(response);
        }
        catch (RuntimeException ex) {
            logger.warn("Ignoring unexpected exception from ResponseAccessor (enable debug logs)");
            logger.debug("Raw response accessor exception", (Throwable)ex);
        }
    }
}

