/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.server.rpc;

import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.server.rpc.RequestReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public final class OutputStreamTransportContext
implements RequestReceiver.TransportContext {
    private final OutputStream out;

    public OutputStreamTransportContext(OutputStream out) {
        Validate.notNull(out);
        this.out = out;
    }

    @Override
    public void send(InputStream response, int responseLength, boolean isFinal) throws IOException {
        Validate.notNull(response);
        if (isFinal) {
            IoUtil.copy(response, this.out);
            this.out.flush();
            this.out.close();
        }
    }

    @Override
    public RequestReceiver.RequestContext getRequestContext() {
        return new RequestReceiver.RequestContext(){

            @Override
            public String getUserAgent() {
                return null;
            }

            @Override
            public String getSession() {
                return null;
            }

            @Override
            public String getServiceId() {
                return null;
            }

            @Override
            public String getOperationId() {
                return null;
            }

            @Override
            public String getAcceptLanguage() {
                return null;
            }

            @Override
            public Map<String, String> getAllProperties() {
                return Collections.emptyMap();
            }
        };
    }

    @Override
    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }
}

