/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureUtil {
    private static final Logger logger = LoggerFactory.getLogger(CompletableFutureUtil.class);

    private CompletableFutureUtil() {
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(t);
        return f;
    }

    public static <T> CompletionStage<T> safeSupply(Supplier<CompletionStage<T>> supplier) {
        CompletionStage<T> future;
        Objects.requireNonNull(supplier);
        try {
            future = supplier.get();
        }
        catch (RuntimeException ex) {
            return CompletableFutureUtil.failedFuture(ex);
        }
        if (future == null) {
            logger.error("Supplier {} returned null future", supplier);
            return CompletableFutureUtil.failedFuture(new IllegalStateException("Supplier " + supplier + " returned null future"));
        }
        return future;
    }
}

