/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.zip.CRC32;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final String MASK = "********";
    private static final int MASK_LEN = "********".length();

    public static String strip(String input, String toStrip) {
        int end;
        int start;
        int strLen;
        if (input == null || toStrip == null || (strLen = input.length()) == 0) {
            return input;
        }
        for (start = 0; start != strLen && toStrip.indexOf(input.charAt(start)) != -1; ++start) {
        }
        if (start == strLen) {
            return EMPTY;
        }
        for (end = input.length(); end != 0 && toStrip.indexOf(input.charAt(end - 1)) != -1; --end) {
        }
        return input.substring(start, end);
    }

    public static String stripEnd(String input, String strip) {
        int end;
        if (input == null || (end = input.length()) == 0) {
            return input;
        }
        while (end != 0 && strip.indexOf(input.charAt(end - 1)) != -1) {
            --end;
        }
        return input.substring(0, end);
    }

    public static boolean isBlank(String input) {
        return StringUtils.isEmpty(input) || (input = input.trim()).isEmpty();
    }

    public static boolean isNotBlank(String input) {
        return !StringUtils.isBlank(input);
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static String uncapitalize(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        char[] c = input.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        input = new String(c);
        return input;
    }

    public static String capitalize(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        char[] c = input.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        input = new String(c);
        return input;
    }

    public static String substringAfter(String input, String delimiter) {
        int pos = input.indexOf(delimiter);
        if (pos == -1) {
            return EMPTY;
        }
        return input.substring(pos + delimiter.length());
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static int countMatches(String str, String sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static int ordinalIndexOf(String input, String searchStr, int ordinal) {
        if (input == null || searchStr == null || searchStr.isEmpty() || ordinal <= 0) {
            return -1;
        }
        int found = 0;
        int index = -1;
        do {
            ++index;
            if ((index = input.indexOf(searchStr, index)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static boolean isNumeric(String input) {
        if (input == null) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            if (Character.isDigit(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String removeEnd(String input, String end) {
        if (input.endsWith(end)) {
            return input.substring(0, input.length() - end.length());
        }
        return input;
    }

    public static String join(Collection<?> collection, String separator) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return EMPTY;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        Iterator<?> iterator = collection.iterator();
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? EMPTY : first.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (first != null) {
            sb.append(first);
        }
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            sb.append(separator);
            if (obj == null) continue;
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String crc32ToHexString(CRC32 checksum) {
        return String.format("%08x", checksum.getValue());
    }

    public static String mask(String sensitiveString) {
        if (sensitiveString == null) {
            return null;
        }
        if (sensitiveString.length() < MASK_LEN) {
            return MASK.substring(0, sensitiveString.length());
        }
        int trimLen = sensitiveString.length() - MASK_LEN;
        String masked = sensitiveString.substring(0, trimLen) + MASK;
        return masked;
    }
}

