/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.rpc.http.impl;

import com.vmware.vapi.protocol.server.rpc.http.Endpoint;

public class HttpEndpoint
implements Endpoint {
    protected String _host;
    protected int _port;
    protected Endpoint.Protocol _protocol;
    protected int _numAcceptors;
    protected int _acceptQueueSize;
    protected int _maxIdleTime;
    protected Endpoint.EndpointType _type = Endpoint.EndpointType.BLOCKING;

    public HttpEndpoint(String host, int port, Endpoint.Protocol protocol) {
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._numAcceptors = 1;
        this._acceptQueueSize = 0;
        this._maxIdleTime = 200000;
    }

    public HttpEndpoint(int port) {
        this("0.0.0.0", port, Endpoint.Protocol.HTTP);
    }

    public HttpEndpoint(String host, int port) {
        this(host, port, Endpoint.Protocol.HTTP);
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public Endpoint.Protocol getProtocol() {
        return this._protocol;
    }

    public String toString() {
        return this._protocol.toString() + ":" + this._host + ":" + Integer.toString(this._port);
    }

    @Override
    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    @Override
    public int getNumAcceptors() {
        return this._numAcceptors;
    }

    @Override
    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    @Override
    public void setNumAcceptors(int acceptors) {
        this._numAcceptors = acceptors;
    }

    @Override
    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    @Override
    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    @Override
    public Endpoint.EndpointType getEndpointType() {
        return this._type;
    }

    @Override
    public void setEndpointType(Endpoint.EndpointType type) {
        this._type = type;
    }
}

