/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.cluster.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.cluster;

public interface ApiService extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.cluster.ApiServiceTypes {

    /**
     * Read the configuration of the NSX API service.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_global_policy.model.ApiServiceConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.ApiServiceConfig get();

    /**
     * Read the configuration of the NSX API service.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.ApiServiceConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.ApiServiceConfig get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read the configuration of the NSX API service.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.ApiServiceConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.ApiServiceConfig> asyncCallback);

    /**
     * Read the configuration of the NSX API service.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.ApiServiceConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.ApiServiceConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read the configuration of the NSX API service. Changes are applied to all nodes
     * in the cluster. The API service on each node will restart after it is updated
     * using this API. There may be a delay of up to a minute or so between the time
     * this API call completes and when the new configuration goes into effect.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param apiServiceConfig (required)
     * @return com.vmware.nsx_global_policy.model.ApiServiceConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.ApiServiceConfig update(com.vmware.nsx_global_policy.model.ApiServiceConfig apiServiceConfig);

    /**
     * Read the configuration of the NSX API service. Changes are applied to all nodes
     * in the cluster. The API service on each node will restart after it is updated
     * using this API. There may be a delay of up to a minute or so between the time
     * this API call completes and when the new configuration goes into effect.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param apiServiceConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.ApiServiceConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.ApiServiceConfig update(com.vmware.nsx_global_policy.model.ApiServiceConfig apiServiceConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read the configuration of the NSX API service. Changes are applied to all nodes
     * in the cluster. The API service on each node will restart after it is updated
     * using this API. There may be a delay of up to a minute or so between the time
     * this API call completes and when the new configuration goes into effect.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.ApiServiceConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param apiServiceConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(com.vmware.nsx_global_policy.model.ApiServiceConfig apiServiceConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.ApiServiceConfig> asyncCallback);

    /**
     * Read the configuration of the NSX API service. Changes are applied to all nodes
     * in the cluster. The API service on each node will restart after it is updated
     * using this API. There may be a delay of up to a minute or so between the time
     * this API call completes and when the new configuration goes into effect.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.ApiServiceConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param apiServiceConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(com.vmware.nsx_global_policy.model.ApiServiceConfig apiServiceConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.ApiServiceConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
