/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.domains.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra.domains;

public interface Groups extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.domains.GroupsTypes {

    /**
     * Delete the group with group_id under domain domain_id. The force query parameter
     * supported on the API is deprecated. Usage of the force query parameter does not
     * alter the behaviour of the API. The API just ignores the force parameter.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param failIfSubtreeExists Do not delete if the group subtree has any entities (optional, default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.Boolean failIfSubtreeExists, java.lang.Boolean force);

    /**
     * Delete the group with group_id under domain domain_id. The force query parameter
     * supported on the API is deprecated. Usage of the force query parameter does not
     * alter the behaviour of the API. The API just ignores the force parameter.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param failIfSubtreeExists Do not delete if the group subtree has any entities (optional, default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.Boolean failIfSubtreeExists, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete the group with group_id under domain domain_id. The force query parameter
     * supported on the API is deprecated. Usage of the force query parameter does not
     * alter the behaviour of the API. The API just ignores the force parameter.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param failIfSubtreeExists Do not delete if the group subtree has any entities (optional, default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.Boolean failIfSubtreeExists, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete the group with group_id under domain domain_id. The force query parameter
     * supported on the API is deprecated. Usage of the force query parameter does not
     * alter the behaviour of the API. The API just ignores the force parameter.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param failIfSubtreeExists Do not delete if the group subtree has any entities (optional, default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.Boolean failIfSubtreeExists, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read group
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @return com.vmware.nsx_global_policy.model.Group
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.Group get(java.lang.String domainId, java.lang.String groupId);

    /**
     * Read group
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.Group
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.Group get(java.lang.String domainId, java.lang.String groupId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read group
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.Group
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String domainId, java.lang.String groupId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.Group> asyncCallback);

    /**
     * Read group
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.Group
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String domainId, java.lang.String groupId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.Group> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List Groups for a domain. Groups can be filtered using member_types query
     * parameter, which returns the groups that contains the specified member types.
     * Multiple member types can be provided as comma separated values. The API also
     * return groups having member type that are subset of provided member_types.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param memberTypes Comma Separated Member types (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_global_policy.model.GroupListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.GroupListResult list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String memberTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List Groups for a domain. Groups can be filtered using member_types query
     * parameter, which returns the groups that contains the specified member types.
     * Multiple member types can be provided as comma separated values. The API also
     * return groups having member type that are subset of provided member_types.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param memberTypes Comma Separated Member types (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.GroupListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.GroupListResult list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String memberTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List Groups for a domain. Groups can be filtered using member_types query
     * parameter, which returns the groups that contains the specified member types.
     * Multiple member types can be provided as comma separated values. The API also
     * return groups having member type that are subset of provided member_types.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.GroupListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param memberTypes Comma Separated Member types (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String memberTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.GroupListResult> asyncCallback);

    /**
     * List Groups for a domain. Groups can be filtered using member_types query
     * parameter, which returns the groups that contains the specified member types.
     * Multiple member types can be provided as comma separated values. The API also
     * return groups having member type that are subset of provided member_types.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.GroupListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param memberTypes Comma Separated Member types (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.String memberTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.GroupListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, patch the group. Group created with Kubernetes membership
     * criteria includes only Antrea reported inventory as its members. Once created,
     * Groups with Identity (Directory) Group members should be updated with the new
     * Distinguished Name in case it is changed on AD Server. Maximum of 500 malicious
     * IP Groups (i.e Group with criteria having IPAddress equals All MALICIOUS_IP)
     * should be created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group);

    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, patch the group. Group created with Kubernetes membership
     * criteria includes only Antrea reported inventory as its members. Once created,
     * Groups with Identity (Directory) Group members should be updated with the new
     * Distinguished Name in case it is changed on AD Server. Maximum of 500 malicious
     * IP Groups (i.e Group with criteria having IPAddress equals All MALICIOUS_IP)
     * should be created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, patch the group. Group created with Kubernetes membership
     * criteria includes only Antrea reported inventory as its members. Once created,
     * Groups with Identity (Directory) Group members should be updated with the new
     * Distinguished Name in case it is changed on AD Server. Maximum of 500 malicious
     * IP Groups (i.e Group with criteria having IPAddress equals All MALICIOUS_IP)
     * should be created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, patch the group. Group created with Kubernetes membership
     * criteria includes only Antrea reported inventory as its members. Once created,
     * Groups with Identity (Directory) Group members should be updated with the new
     * Distinguished Name in case it is changed on AD Server. Maximum of 500 malicious
     * IP Groups (i.e Group with criteria having IPAddress equals All MALICIOUS_IP)
     * should be created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, update the group. Avoid creating groups with multiple
     * MACAddressExpression and IPAddressExpression. In future releases, group will be
     * restricted to contain a single MACAddressExpression and IPAddressExpression
     * along with other expressions. To group IPAddresses or MACAddresses, use nested
     * groups instead of multiple IPAddressExpressions/MACAddressExpression. Group
     * created with Kubernetes membership criteria includes only Antrea reported
     * inventory as its members. Once created, Groups with Identity (Directory) Group
     * members should be updated with the new Distinguished Name in case it is changed
     * on AD Server. Maximum of 500 malicious IP Groups (i.e Group with criteria having
     * IPAddress equals All MALICIOUS_IP) should be created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @return com.vmware.nsx_global_policy.model.Group
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.Group update(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group);

    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, update the group. Avoid creating groups with multiple
     * MACAddressExpression and IPAddressExpression. In future releases, group will be
     * restricted to contain a single MACAddressExpression and IPAddressExpression
     * along with other expressions. To group IPAddresses or MACAddresses, use nested
     * groups instead of multiple IPAddressExpressions/MACAddressExpression. Group
     * created with Kubernetes membership criteria includes only Antrea reported
     * inventory as its members. Once created, Groups with Identity (Directory) Group
     * members should be updated with the new Distinguished Name in case it is changed
     * on AD Server. Maximum of 500 malicious IP Groups (i.e Group with criteria having
     * IPAddress equals All MALICIOUS_IP) should be created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.Group
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.Group update(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, update the group. Avoid creating groups with multiple
     * MACAddressExpression and IPAddressExpression. In future releases, group will be
     * restricted to contain a single MACAddressExpression and IPAddressExpression
     * along with other expressions. To group IPAddresses or MACAddresses, use nested
     * groups instead of multiple IPAddressExpressions/MACAddressExpression. Group
     * created with Kubernetes membership criteria includes only Antrea reported
     * inventory as its members. Once created, Groups with Identity (Directory) Group
     * members should be updated with the new Distinguished Name in case it is changed
     * on AD Server. Maximum of 500 malicious IP Groups (i.e Group with criteria having
     * IPAddress equals All MALICIOUS_IP) should be created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.Group
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.Group> asyncCallback);

    /**
     * If a group with the group-id is not already present, create a new group. If it
     * already exists, update the group. Avoid creating groups with multiple
     * MACAddressExpression and IPAddressExpression. In future releases, group will be
     * restricted to contain a single MACAddressExpression and IPAddressExpression
     * along with other expressions. To group IPAddresses or MACAddresses, use nested
     * groups instead of multiple IPAddressExpressions/MACAddressExpression. Group
     * created with Kubernetes membership criteria includes only Antrea reported
     * inventory as its members. Once created, Groups with Identity (Directory) Group
     * members should be updated with the new Distinguished Name in case it is changed
     * on AD Server. Maximum of 500 malicious IP Groups (i.e Group with criteria having
     * IPAddress equals All MALICIOUS_IP) should be created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.Group
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param group (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String domainId, java.lang.String groupId, com.vmware.nsx_global_policy.model.Group group, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.Group> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
