/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

public final class BinaryPacketData implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "BinaryPacketData";

    private java.lang.String payload;

    private java.lang.Long frameSize;

    private final java.lang.String resourceType = "BinaryPacketData";

    private java.lang.Boolean routed;

    private java.lang.String transportType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BinaryPacketData() {
    }

    protected BinaryPacketData(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Up to 1000 bytes of payload may be supplied (with a base64-encoded length of
     * 1336 bytes.) Additional bytes of traceflow metadata will be appended to the
     * payload. The payload must contain all headers (Ethernet, IP, etc). Note that
     * VLAN is not supported in the logical space. Hence, payload must not contain
     * 802.1Q headers.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPayload() {
        return this.payload;
    }

    /**
     * Up to 1000 bytes of payload may be supplied (with a base64-encoded length of
     * 1336 bytes.) Additional bytes of traceflow metadata will be appended to the
     * payload. The payload must contain all headers (Ethernet, IP, etc). Note that
     * VLAN is not supported in the logical space. Hence, payload must not contain
     * 802.1Q headers.
     *
     * @param payload New value for the property.
     */
    public void setPayload(java.lang.String payload) {
        this.payload = payload;
    }

    /**
     * If the requested frame_size is too small (given the payload and traceflow
     * metadata requirement of 16 bytes), the traceflow request will fail with an
     * appropriate message. The frame will be zero padded to the requested size.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFrameSize() {
        return this.frameSize;
    }

    /**
     * If the requested frame_size is too small (given the payload and traceflow
     * metadata requirement of 16 bytes), the traceflow request will fail with an
     * appropriate message. The frame will be zero padded to the requested size.
     * format: int64
     *
     * @param frameSize New value for the property.
     */
    public void setFrameSize(java.lang.Long frameSize) {
        this.frameSize = frameSize;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#RESOURCE_TYPE_BINARYPACKETDATA}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#RESOURCE_TYPE_FIELDSPACKETDATA}</li>
     * </ul> Packet configuration
     * The value of this property is automatically populated to {@code "BinaryPacketData"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * When this flag is set, traceflow packet will have its destination overwritten as
     * the gateway address of the logical router to which the source logical switch is
     * connected. More specifically: - For ARP request, the target IP will be
     * overwritten as gateway IP if the target IP is not in the same subnet of gateway.
     * - For ARP response, the target IP and destination MAC will be overwritten as
     * gateway IP/MAC respectively, if the target IP is not in the same subnet of
     * gateway. - For IP packet, the destination MAC will be overwritten as gateway
     * MAC. However, this flag will not be effective when injecting the traceflow
     * packet to a VLAN backed port. This is because the gateway in this case is a
     * physical gateway that is outside the scope of NSX. Therefore, users need to
     * manually populate the gateway MAC address. If the user still sets this flag in
     * this case, a validation error will be thrown.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRouted() {
        return this.routed;
    }

    /**
     * When this flag is set, traceflow packet will have its destination overwritten as
     * the gateway address of the logical router to which the source logical switch is
     * connected. More specifically: - For ARP request, the target IP will be
     * overwritten as gateway IP if the target IP is not in the same subnet of gateway.
     * - For ARP response, the target IP and destination MAC will be overwritten as
     * gateway IP/MAC respectively, if the target IP is not in the same subnet of
     * gateway. - For IP packet, the destination MAC will be overwritten as gateway
     * MAC. However, this flag will not be effective when injecting the traceflow
     * packet to a VLAN backed port. This is because the gateway in this case is a
     * physical gateway that is outside the scope of NSX. Therefore, users need to
     * manually populate the gateway MAC address. If the user still sets this flag in
     * this case, a validation error will be thrown.
     *
     * @param routed New value for the property.
     */
    public void setRouted(java.lang.Boolean routed) {
        this.routed = routed;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_BROADCAST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_UNICAST}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_MULTICAST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_UNKNOWN}</li> </ul>
     * This type takes effect only for IP packet.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportType() {
        return this.transportType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_BROADCAST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_UNICAST}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_MULTICAST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_UNKNOWN}</li> </ul>
     * This type takes effect only for IP packet.
     *
     * @param transportType New value for the property.
     */
    public void setTransportType(java.lang.String transportType) {
        this.transportType = transportType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.binaryPacketData;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("payload",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.payload, this._getType().getField("payload")));
        structValue.setField("frame_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.frameSize, this._getType().getField("frame_size")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("routed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.routed, this._getType().getField("routed")));
        structValue.setField("transport_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportType, this._getType().getField("transport_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.binaryPacketData;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.binaryPacketData.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BinaryPacketData _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BinaryPacketData(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BinaryPacketData _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BinaryPacketData(structValue);
    }

    /**
     * Builder class for {@link BinaryPacketData}.
     */
    public static final class Builder {
        private java.lang.String payload;
        private java.lang.Long frameSize;
        private java.lang.Boolean routed;
        private java.lang.String transportType;

        /**
         * Constructor with parameters for the required properties of
         * {@link BinaryPacketData}.
         */
        public Builder() {
        }

        /**
         * Up to 1000 bytes of payload may be supplied (with a base64-encoded length of
         * 1336 bytes.) Additional bytes of traceflow metadata will be appended to the
         * payload. The payload must contain all headers (Ethernet, IP, etc). Note that
         * VLAN is not supported in the logical space. Hence, payload must not contain
         * 802.1Q headers.
         *
         * @param payload New value for the property.
         */
        public Builder setPayload(java.lang.String payload) {
            this.payload = payload;
            return this;
        }

        /**
         * If the requested frame_size is too small (given the payload and traceflow
         * metadata requirement of 16 bytes), the traceflow request will fail with an
         * appropriate message. The frame will be zero padded to the requested size.
         * format: int64
         *
         * @param frameSize New value for the property.
         */
        public Builder setFrameSize(java.lang.Long frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        /**
         * When this flag is set, traceflow packet will have its destination overwritten as
         * the gateway address of the logical router to which the source logical switch is
         * connected. More specifically: - For ARP request, the target IP will be
         * overwritten as gateway IP if the target IP is not in the same subnet of gateway.
         * - For ARP response, the target IP and destination MAC will be overwritten as
         * gateway IP/MAC respectively, if the target IP is not in the same subnet of
         * gateway. - For IP packet, the destination MAC will be overwritten as gateway
         * MAC. However, this flag will not be effective when injecting the traceflow
         * packet to a VLAN backed port. This is because the gateway in this case is a
         * physical gateway that is outside the scope of NSX. Therefore, users need to
         * manually populate the gateway MAC address. If the user still sets this flag in
         * this case, a validation error will be thrown.
         *
         * @param routed New value for the property.
         */
        public Builder setRouted(java.lang.Boolean routed) {
            this.routed = routed;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_BROADCAST}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_UNICAST}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_MULTICAST}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.PacketData#TRANSPORT_TYPE_UNKNOWN}</li> </ul>
         * This type takes effect only for IP packet.
         *
         * @param transportType New value for the property.
         */
        public Builder setTransportType(java.lang.String transportType) {
            this.transportType = transportType;
            return this;
        }

        public BinaryPacketData build() {
            BinaryPacketData result = new BinaryPacketData();
            result.setPayload(this.payload);
            result.setFrameSize(this.frameSize);
            result.setRouted(this.routed);
            result.setTransportType(this.transportType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("payload", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("payload",
                                                                                "payload",
                                                                                "getPayload",
                                                                                "setPayload");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("frame_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("frame_size",
                                                                                "frameSize",
                                                                                "getFrameSize",
                                                                                "setFrameSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("routed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("routed",
                                                                                "routed",
                                                                                "getRouted",
                                                                                "setRouted");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_type",
                                                                                "transportType",
                                                                                "getTransportType",
                                                                                "setTransportType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.binary_packet_data",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.BinaryPacketData.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "BinaryPacketData");
    }
}

