/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Information about a single LDAP server.
 */
public final class IdentitySourceLdapServer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String bindIdentity;

    private java.util.List<java.lang.String> certificates;

    private java.lang.Boolean enabled;

    private java.lang.String password;

    private java.lang.String url;

    private java.lang.Boolean useStarttls;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IdentitySourceLdapServer() {
    }

    protected IdentitySourceLdapServer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A username used to authenticate to the directory when admnistering roles in NSX.
     * This user should have privileges to search the LDAP directory for groups and
     * users. This user is also used in some cases (OpenLDAP) to look up an NSX user's
     * distinguished name based on their NSX login name. If omitted, NSX will
     * authenticate to the LDAP server using an LDAP anonymous bind operation. For
     * Active Directory, provide a userPrincipalName (e.g. administrator@airius.com) or
     * the full distinguished nane. For OpenLDAP, provide the distinguished name of the
     * user (e.g. uid=admin, cn=airius, dc=com).
     *
     * @return The current value of the property.
     */
    public java.lang.String getBindIdentity() {
        return this.bindIdentity;
    }

    /**
     * A username used to authenticate to the directory when admnistering roles in NSX.
     * This user should have privileges to search the LDAP directory for groups and
     * users. This user is also used in some cases (OpenLDAP) to look up an NSX user's
     * distinguished name based on their NSX login name. If omitted, NSX will
     * authenticate to the LDAP server using an LDAP anonymous bind operation. For
     * Active Directory, provide a userPrincipalName (e.g. administrator@airius.com) or
     * the full distinguished nane. For OpenLDAP, provide the distinguished name of the
     * user (e.g. uid=admin, cn=airius, dc=com).
     *
     * @param bindIdentity New value for the property.
     */
    public void setBindIdentity(java.lang.String bindIdentity) {
        this.bindIdentity = bindIdentity;
    }

    /**
     * If using LDAPS or STARTTLS, provide the X.509 certificate of the LDAP server in
     * PEM format. This property is not required when connecting without TLS encryption
     * and is ignored in that case.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getCertificates() {
        return this.certificates;
    }

    /**
     * If using LDAPS or STARTTLS, provide the X.509 certificate of the LDAP server in
     * PEM format. This property is not required when connecting without TLS encryption
     * and is ignored in that case.
     *
     * @param certificates New value for the property.
     */
    public void setCertificates(java.util.List<java.lang.String> certificates) {
        this.certificates = certificates;
    }

    /**
     * Allows the LDAP server to be enabled or disabled. When disabled, this LDAP
     * server will not be used to authenticate users.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Allows the LDAP server to be enabled or disabled. When disabled, this LDAP
     * server will not be used to authenticate users.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * A password used when authenticating to the directory.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassword() {
        return this.password;
    }

    /**
     * A password used when authenticating to the directory.
     *
     * @param password New value for the property.
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * The URL for the LDAP server. Supported URL schemes are LDAP and LDAPS. Either a
     * hostname or an IP address may be given, and the port number is optional and
     * defaults to 389 for the LDAP scheme and 636 for the LDAPS scheme.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUrl() {
        return this.url;
    }

    /**
     * The URL for the LDAP server. Supported URL schemes are LDAP and LDAPS. Either a
     * hostname or an IP address may be given, and the port number is optional and
     * defaults to 389 for the LDAP scheme and 636 for the LDAPS scheme.
     *
     * @param url New value for the property.
     */
    public void setUrl(java.lang.String url) {
        this.url = url;
    }

    /**
     * If set to true, Use the StartTLS extended operation to upgrade the connection to
     * TLS before sending any sensitive information. The LDAP server must support the
     * StartTLS extended operation in order for this protocol to operate correctly.
     * This option is ignored if the URL scheme is LDAPS.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUseStarttls() {
        return this.useStarttls;
    }

    /**
     * If set to true, Use the StartTLS extended operation to upgrade the connection to
     * TLS before sending any sensitive information. The LDAP server must support the
     * StartTLS extended operation in order for this protocol to operate correctly.
     * This option is ignored if the URL scheme is LDAPS.
     *
     * @param useStarttls New value for the property.
     */
    public void setUseStarttls(java.lang.Boolean useStarttls) {
        this.useStarttls = useStarttls;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.identitySourceLdapServer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("bind_identity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bindIdentity, this._getType().getField("bind_identity")));
        structValue.setField("certificates",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificates, this._getType().getField("certificates")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.password, this._getType().getField("password")));
        structValue.setField("url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.url, this._getType().getField("url")));
        structValue.setField("use_starttls",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.useStarttls, this._getType().getField("use_starttls")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.identitySourceLdapServer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.identitySourceLdapServer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IdentitySourceLdapServer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IdentitySourceLdapServer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IdentitySourceLdapServer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IdentitySourceLdapServer(structValue);
    }

    /**
     * Builder class for {@link IdentitySourceLdapServer}.
     */
    public static final class Builder {
        private java.lang.String bindIdentity;
        private java.util.List<java.lang.String> certificates;
        private java.lang.Boolean enabled;
        private java.lang.String password;
        private java.lang.String url;
        private java.lang.Boolean useStarttls;

        /**
         * Constructor with parameters for the required properties of
         * {@link IdentitySourceLdapServer}.
         */
        public Builder() {
        }

        /**
         * A username used to authenticate to the directory when admnistering roles in NSX.
         * This user should have privileges to search the LDAP directory for groups and
         * users. This user is also used in some cases (OpenLDAP) to look up an NSX user's
         * distinguished name based on their NSX login name. If omitted, NSX will
         * authenticate to the LDAP server using an LDAP anonymous bind operation. For
         * Active Directory, provide a userPrincipalName (e.g. administrator@airius.com) or
         * the full distinguished nane. For OpenLDAP, provide the distinguished name of the
         * user (e.g. uid=admin, cn=airius, dc=com).
         *
         * @param bindIdentity New value for the property.
         */
        public Builder setBindIdentity(java.lang.String bindIdentity) {
            this.bindIdentity = bindIdentity;
            return this;
        }

        /**
         * If using LDAPS or STARTTLS, provide the X.509 certificate of the LDAP server in
         * PEM format. This property is not required when connecting without TLS encryption
         * and is ignored in that case.
         *
         * @param certificates New value for the property.
         */
        public Builder setCertificates(java.util.List<java.lang.String> certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Allows the LDAP server to be enabled or disabled. When disabled, this LDAP
         * server will not be used to authenticate users.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * A password used when authenticating to the directory.
         *
         * @param password New value for the property.
         */
        public Builder setPassword(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * The URL for the LDAP server. Supported URL schemes are LDAP and LDAPS. Either a
         * hostname or an IP address may be given, and the port number is optional and
         * defaults to 389 for the LDAP scheme and 636 for the LDAPS scheme.
         *
         * @param url New value for the property.
         */
        public Builder setUrl(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * If set to true, Use the StartTLS extended operation to upgrade the connection to
         * TLS before sending any sensitive information. The LDAP server must support the
         * StartTLS extended operation in order for this protocol to operate correctly.
         * This option is ignored if the URL scheme is LDAPS.
         *
         * @param useStarttls New value for the property.
         */
        public Builder setUseStarttls(java.lang.Boolean useStarttls) {
            this.useStarttls = useStarttls;
            return this;
        }

        public IdentitySourceLdapServer build() {
            IdentitySourceLdapServer result = new IdentitySourceLdapServer();
            result.setBindIdentity(this.bindIdentity);
            result.setCertificates(this.certificates);
            result.setEnabled(this.enabled);
            result.setPassword(this.password);
            result.setUrl(this.url);
            result.setUseStarttls(this.useStarttls);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("bind_identity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bind_identity",
                                                                                "bindIdentity",
                                                                                "getBindIdentity",
                                                                                "setBindIdentity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("certificates", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificates",
                                                                                "certificates",
                                                                                "getCertificates",
                                                                                "setCertificates");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password",
                                                                                "password",
                                                                                "getPassword",
                                                                                "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("url",
                                                                                "url",
                                                                                "getUrl",
                                                                                "setUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("use_starttls", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("use_starttls",
                                                                                "useStarttls",
                                                                                "getUseStarttls",
                                                                                "setUseStarttls");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.identity_source_ldap_server",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.IdentitySourceLdapServer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

