/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Gives the statistics of a NAT rule per enforcement point.
 */
public final class PolicyNatRuleStatisticsPerEnforcementPoint implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String enforcementPointPath;

    private java.lang.String rulePath;

    private java.util.List<com.vmware.nsx_global_policy.model.PolicyNatRuleStatistics> ruleStatistics;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyNatRuleStatisticsPerEnforcementPoint() {
    }

    protected PolicyNatRuleStatisticsPerEnforcementPoint(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Policy Path referencing the enforcement point from where the statistics are
     * fetched.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEnforcementPointPath() {
        return this.enforcementPointPath;
    }

    /**
     * Policy Path referencing the enforcement point from where the statistics are
     * fetched.
     *
     * @param enforcementPointPath New value for the property.
     */
    public void setEnforcementPointPath(java.lang.String enforcementPointPath) {
        this.enforcementPointPath = enforcementPointPath;
    }

    /**
     * Path of NAT Rule.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRulePath() {
        return this.rulePath;
    }

    /**
     * Path of NAT Rule.
     *
     * @param rulePath New value for the property.
     */
    public void setRulePath(java.lang.String rulePath) {
        this.rulePath = rulePath;
    }

    /**
     * Gives NAT rule stats on an enforcement point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.PolicyNatRuleStatistics> getRuleStatistics() {
        return this.ruleStatistics;
    }

    /**
     * Gives NAT rule stats on an enforcement point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ruleStatistics New value for the property.
     */
    public void setRuleStatistics(java.util.List<com.vmware.nsx_global_policy.model.PolicyNatRuleStatistics> ruleStatistics) {
        this.ruleStatistics = ruleStatistics;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerEnforcementPoint;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("enforcement_point_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enforcementPointPath, this._getType().getField("enforcement_point_path")));
        structValue.setField("rule_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rulePath, this._getType().getField("rule_path")));
        structValue.setField("rule_statistics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleStatistics, this._getType().getField("rule_statistics")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerEnforcementPoint;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatisticsPerEnforcementPoint.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyNatRuleStatisticsPerEnforcementPoint _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyNatRuleStatisticsPerEnforcementPoint(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyNatRuleStatisticsPerEnforcementPoint _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyNatRuleStatisticsPerEnforcementPoint(structValue);
    }

    /**
     * Builder class for {@link PolicyNatRuleStatisticsPerEnforcementPoint}.
     */
    public static final class Builder {
        private java.lang.String enforcementPointPath;
        private java.lang.String rulePath;
        private java.util.List<com.vmware.nsx_global_policy.model.PolicyNatRuleStatistics> ruleStatistics;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyNatRuleStatisticsPerEnforcementPoint}.
         */
        public Builder() {
        }

        /**
         * Policy Path referencing the enforcement point from where the statistics are
         * fetched.
         *
         * @param enforcementPointPath New value for the property.
         */
        public Builder setEnforcementPointPath(java.lang.String enforcementPointPath) {
            this.enforcementPointPath = enforcementPointPath;
            return this;
        }

        /**
         * Path of NAT Rule.
         *
         * @param rulePath New value for the property.
         */
        public Builder setRulePath(java.lang.String rulePath) {
            this.rulePath = rulePath;
            return this;
        }

        /**
         * Gives NAT rule stats on an enforcement point.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ruleStatistics New value for the property.
         */
        public Builder setRuleStatistics(java.util.List<com.vmware.nsx_global_policy.model.PolicyNatRuleStatistics> ruleStatistics) {
            this.ruleStatistics = ruleStatistics;
            return this;
        }

        public PolicyNatRuleStatisticsPerEnforcementPoint build() {
            PolicyNatRuleStatisticsPerEnforcementPoint result = new PolicyNatRuleStatisticsPerEnforcementPoint();
            result.setEnforcementPointPath(this.enforcementPointPath);
            result.setRulePath(this.rulePath);
            result.setRuleStatistics(this.ruleStatistics);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("enforcement_point_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enforcement_point_path",
                                                                                "enforcementPointPath",
                                                                                "getEnforcementPointPath",
                                                                                "setEnforcementPointPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_path",
                                                                                "rulePath",
                                                                                "getRulePath",
                                                                                "setRulePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_statistics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.policyNatRuleStatistics; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_statistics",
                                                                                "ruleStatistics",
                                                                                "getRuleStatistics",
                                                                                "setRuleStatistics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.policy_nat_rule_statistics_per_enforcement_point",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsPerEnforcementPoint.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

