/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Segment configuration to attach workloads.
 */
public final class Segment implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ADMIN_STATE_UP = "UP";

    public static final java.lang.String ADMIN_STATE_DOWN = "DOWN";

    public static final java.lang.String REPLICATION_MODE_MTEP = "MTEP";

    public static final java.lang.String REPLICATION_MODE_SOURCE = "SOURCE";

    public static final java.lang.String TYPE_ROUTED = "ROUTED";

    public static final java.lang.String TYPE_EXTENDED = "EXTENDED";

    public static final java.lang.String TYPE_ROUTED_AND_EXTENDED = "ROUTED_AND_EXTENDED";

    public static final java.lang.String TYPE_DISCONNECTED = "DISCONNECTED";

    private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_global_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private java.util.List<com.vmware.nsx_global_policy.model.PortAddressBindingEntry> addressBindings;

    private java.lang.String adminState;

    private com.vmware.nsx_global_policy.model.SegmentAdvancedConfig advancedConfig;

    private java.util.List<com.vmware.nsx_global_policy.model.BridgeProfileConfig> bridgeProfiles;

    private java.lang.String connectivityPath;

    private java.lang.String dhcpConfigPath;

    private java.lang.String domainName;

    private java.lang.Boolean evpnSegment;

    private java.lang.String evpnTenantConfigPath;

    private java.util.List<com.vmware.nsx_global_policy.model.SegmentExtraConfig> extraConfigs;

    private com.vmware.nsx_global_policy.model.FederationConnectivityConfig federationConfig;

    private com.vmware.nsx_global_policy.model.L2Extension l2Extension;

    private java.lang.String lsId;

    private java.lang.String macPoolId;

    private java.util.List<java.lang.String> metadataProxyPaths;

    private java.lang.Long overlayId;

    private java.lang.String replicationMode;

    private java.util.List<com.vmware.nsx_global_policy.model.SegmentSubnet> subnets;

    private java.lang.String transportZonePath;

    private java.lang.String type;

    private java.util.List<java.lang.String> vlanIds;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Segment() {
    }

    protected Segment(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing who owns this object. This is
     * used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing who owns this object. This is
     * used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated their unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated their unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the NSX+
     * service, and path of the object on NSX+ service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the NSX+
     * service, and path of the object on NSX+ service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entities in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entities in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     * Static address binding used for the Segment. This field is deprecated and will
     * be removed in a future release. Please use address_bindings in SegmentPort to
     * configure static bindings.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx_global_policy.model.PortAddressBindingEntry> getAddressBindings() {
        return this.addressBindings;
    }

    /**
     * Static address binding used for the Segment. This field is deprecated and will
     * be removed in a future release. Please use address_bindings in SegmentPort to
     * configure static bindings.
     *
     * @param addressBindings New value for the property.
     */
    @Deprecated
    public void setAddressBindings(java.util.List<com.vmware.nsx_global_policy.model.PortAddressBindingEntry> addressBindings) {
        this.addressBindings = addressBindings;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#ADMIN_STATE_UP}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#ADMIN_STATE_DOWN}</li> </ul> Admin
     * state represents desired state of segment. It does not reflect the state of
     * other logical entities connected/attached to the segment.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminState() {
        return this.adminState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#ADMIN_STATE_UP}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#ADMIN_STATE_DOWN}</li> </ul> Admin
     * state represents desired state of segment. It does not reflect the state of
     * other logical entities connected/attached to the segment.
     *
     * @param adminState New value for the property.
     */
    public void setAdminState(java.lang.String adminState) {
        this.adminState = adminState;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.SegmentAdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    /**
     *
     *
     * @param advancedConfig New value for the property.
     */
    public void setAdvancedConfig(com.vmware.nsx_global_policy.model.SegmentAdvancedConfig advancedConfig) {
        this.advancedConfig = advancedConfig;
    }

    /**
     * Multiple distinct L2 bridge profiles can be configured.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.BridgeProfileConfig> getBridgeProfiles() {
        return this.bridgeProfiles;
    }

    /**
     * Multiple distinct L2 bridge profiles can be configured.
     *
     * @param bridgeProfiles New value for the property.
     */
    public void setBridgeProfiles(java.util.List<com.vmware.nsx_global_policy.model.BridgeProfileConfig> bridgeProfiles) {
        this.bridgeProfiles = bridgeProfiles;
    }

    /**
     * Policy path to the connecting Tier-0 or Tier-1 or label of type Tier0. Valid
     * only for segments created under Infra. This field can only be used for overlay
     * segments. VLAN backed segments cannot have connectivity path set.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectivityPath() {
        return this.connectivityPath;
    }

    /**
     * Policy path to the connecting Tier-0 or Tier-1 or label of type Tier0. Valid
     * only for segments created under Infra. This field can only be used for overlay
     * segments. VLAN backed segments cannot have connectivity path set.
     *
     * @param connectivityPath New value for the property.
     */
    public void setConnectivityPath(java.lang.String connectivityPath) {
        this.connectivityPath = connectivityPath;
    }

    /**
     * Policy path to DHCP server or relay configuration to use for all IPv4 & IPv6
     * subnets configured on this segment.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDhcpConfigPath() {
        return this.dhcpConfigPath;
    }

    /**
     * Policy path to DHCP server or relay configuration to use for all IPv4 & IPv6
     * subnets configured on this segment.
     *
     * @param dhcpConfigPath New value for the property.
     */
    public void setDhcpConfigPath(java.lang.String dhcpConfigPath) {
        this.dhcpConfigPath = dhcpConfigPath;
    }

    /**
     * DNS domain name
     *
     * @return The current value of the property.
     */
    public java.lang.String getDomainName() {
        return this.domainName;
    }

    /**
     * DNS domain name
     *
     * @param domainName New value for the property.
     */
    public void setDomainName(java.lang.String domainName) {
        this.domainName = domainName;
    }

    /**
     * Flag to indicate if the Segment is a Child-Segment of type EVPN.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEvpnSegment() {
        return this.evpnSegment;
    }

    /**
     * Flag to indicate if the Segment is a Child-Segment of type EVPN.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param evpnSegment New value for the property.
     */
    public void setEvpnSegment(java.lang.Boolean evpnSegment) {
        this.evpnSegment = evpnSegment;
    }

    /**
     * Policy path to the EvpnTenantConfig resource. Supported only for Route-Server
     * Evpn Mode. Supported only for Overlay Segments. This will be populated for both
     * Parent and Child segments participating in Evpn Route-Server Mode.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEvpnTenantConfigPath() {
        return this.evpnTenantConfigPath;
    }

    /**
     * Policy path to the EvpnTenantConfig resource. Supported only for Route-Server
     * Evpn Mode. Supported only for Overlay Segments. This will be populated for both
     * Parent and Child segments participating in Evpn Route-Server Mode.
     *
     * @param evpnTenantConfigPath New value for the property.
     */
    public void setEvpnTenantConfigPath(java.lang.String evpnTenantConfigPath) {
        this.evpnTenantConfigPath = evpnTenantConfigPath;
    }

    /**
     * This property could be used for vendor specific configuration in key value
     * string pairs, the setting in extra_configs will be automatically inheritted by
     * segment ports in the Segment.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.SegmentExtraConfig> getExtraConfigs() {
        return this.extraConfigs;
    }

    /**
     * This property could be used for vendor specific configuration in key value
     * string pairs, the setting in extra_configs will be automatically inheritted by
     * segment ports in the Segment.
     *
     * @param extraConfigs New value for the property.
     */
    public void setExtraConfigs(java.util.List<com.vmware.nsx_global_policy.model.SegmentExtraConfig> extraConfigs) {
        this.extraConfigs = extraConfigs;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.FederationConnectivityConfig getFederationConfig() {
        return this.federationConfig;
    }

    /**
     *
     *
     * @param federationConfig New value for the property.
     */
    public void setFederationConfig(com.vmware.nsx_global_policy.model.FederationConnectivityConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.L2Extension getL2Extension() {
        return this.l2Extension;
    }

    /**
     *
     *
     * @param l2Extension New value for the property.
     */
    public void setL2Extension(com.vmware.nsx_global_policy.model.L2Extension l2Extension) {
        this.l2Extension = l2Extension;
    }

    /**
     * This property is deprecated. The property will continue to work as expected for
     * existing segments. The segments that are newly created with ls_id will be
     * ignored. Sepcify pre-creted logical switch id for Segment.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getLsId() {
        return this.lsId;
    }

    /**
     * This property is deprecated. The property will continue to work as expected for
     * existing segments. The segments that are newly created with ls_id will be
     * ignored. Sepcify pre-creted logical switch id for Segment.
     *
     * @param lsId New value for the property.
     */
    @Deprecated
    public void setLsId(java.lang.String lsId) {
        this.lsId = lsId;
    }

    /**
     * Mac pool id that associated with a Segment.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMacPoolId() {
        return this.macPoolId;
    }

    /**
     * Mac pool id that associated with a Segment.
     *
     * @param macPoolId New value for the property.
     */
    public void setMacPoolId(java.lang.String macPoolId) {
        this.macPoolId = macPoolId;
    }

    /**
     * Policy path to metadata proxy configuration. Multiple distinct MD proxies can be
     * configured.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getMetadataProxyPaths() {
        return this.metadataProxyPaths;
    }

    /**
     * Policy path to metadata proxy configuration. Multiple distinct MD proxies can be
     * configured.
     *
     * @param metadataProxyPaths New value for the property.
     */
    public void setMetadataProxyPaths(java.util.List<java.lang.String> metadataProxyPaths) {
        this.metadataProxyPaths = metadataProxyPaths;
    }

    /**
     * Used for overlay connectivity of segments. The overlay_id should be allocated
     * from the pool as definied by enforcement-point. If not provided, it is
     * auto-allocated from the default pool on the enforcement-point. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getOverlayId() {
        return this.overlayId;
    }

    /**
     * Used for overlay connectivity of segments. The overlay_id should be allocated
     * from the pool as definied by enforcement-point. If not provided, it is
     * auto-allocated from the default pool on the enforcement-point. format: int32
     *
     * @param overlayId New value for the property.
     */
    public void setOverlayId(java.lang.Long overlayId) {
        this.overlayId = overlayId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#REPLICATION_MODE_MTEP}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.Segment#REPLICATION_MODE_SOURCE}</li>
     * </ul> If this field is not set for overlay segment, then the default of MTEP
     * will be used.
     *
     * @return The current value of the property.
     */
    public java.lang.String getReplicationMode() {
        return this.replicationMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#REPLICATION_MODE_MTEP}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.Segment#REPLICATION_MODE_SOURCE}</li>
     * </ul> If this field is not set for overlay segment, then the default of MTEP
     * will be used.
     *
     * @param replicationMode New value for the property.
     */
    public void setReplicationMode(java.lang.String replicationMode) {
        this.replicationMode = replicationMode;
    }

    /**
     * Subnet configuration. Max 1 subnet
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.SegmentSubnet> getSubnets() {
        return this.subnets;
    }

    /**
     * Subnet configuration. Max 1 subnet
     *
     * @param subnets New value for the property.
     */
    public void setSubnets(java.util.List<com.vmware.nsx_global_policy.model.SegmentSubnet> subnets) {
        this.subnets = subnets;
    }

    /**
     * Policy path to the transport zone. Supported for VLAN backed segments as well as
     * Overlay Segments. - This field is required for VLAN backed Segments. - For
     * overlay Segments, it is auto assigned if only one transport zone exists in the
     * enforcement point. Default transport zone is auto assigned for overlay segments
     * if none specified.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportZonePath() {
        return this.transportZonePath;
    }

    /**
     * Policy path to the transport zone. Supported for VLAN backed segments as well as
     * Overlay Segments. - This field is required for VLAN backed Segments. - For
     * overlay Segments, it is auto assigned if only one transport zone exists in the
     * enforcement point. Default transport zone is auto assigned for overlay segments
     * if none specified.
     *
     * @param transportZonePath New value for the property.
     */
    public void setTransportZonePath(java.lang.String transportZonePath) {
        this.transportZonePath = transportZonePath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#TYPE_ROUTED}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#TYPE_EXTENDED}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#TYPE_ROUTED_AND_EXTENDED}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.Segment#TYPE_DISCONNECTED}</li> </ul>
     * Segment type based on configuration.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#TYPE_ROUTED}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#TYPE_EXTENDED}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.Segment#TYPE_ROUTED_AND_EXTENDED}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.Segment#TYPE_DISCONNECTED}</li> </ul>
     * Segment type based on configuration.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

    /**
     * VLAN ids for a VLAN backed Segment. Can be a VLAN id or a range of VLAN ids
     * specified with '-' in between.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getVlanIds() {
        return this.vlanIds;
    }

    /**
     * VLAN ids for a VLAN backed Segment. Can be a VLAN id or a range of VLAN ids
     * specified with '-' in between.
     *
     * @param vlanIds New value for the property.
     */
    public void setVlanIds(java.util.List<java.lang.String> vlanIds) {
        this.vlanIds = vlanIds;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.segment;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("address_bindings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.addressBindings, this._getType().getField("address_bindings")));
        structValue.setField("admin_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminState, this._getType().getField("admin_state")));
        structValue.setField("advanced_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.advancedConfig, this._getType().getField("advanced_config")));
        structValue.setField("bridge_profiles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bridgeProfiles, this._getType().getField("bridge_profiles")));
        structValue.setField("connectivity_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectivityPath, this._getType().getField("connectivity_path")));
        structValue.setField("dhcp_config_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpConfigPath, this._getType().getField("dhcp_config_path")));
        structValue.setField("domain_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainName, this._getType().getField("domain_name")));
        structValue.setField("evpn_segment",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.evpnSegment, this._getType().getField("evpn_segment")));
        structValue.setField("evpn_tenant_config_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.evpnTenantConfigPath, this._getType().getField("evpn_tenant_config_path")));
        structValue.setField("extra_configs",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.extraConfigs, this._getType().getField("extra_configs")));
        structValue.setField("federation_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationConfig, this._getType().getField("federation_config")));
        structValue.setField("l2_extension",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.l2Extension, this._getType().getField("l2_extension")));
        structValue.setField("ls_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lsId, this._getType().getField("ls_id")));
        structValue.setField("mac_pool_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.macPoolId, this._getType().getField("mac_pool_id")));
        structValue.setField("metadata_proxy_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.metadataProxyPaths, this._getType().getField("metadata_proxy_paths")));
        structValue.setField("overlay_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overlayId, this._getType().getField("overlay_id")));
        structValue.setField("replication_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.replicationMode, this._getType().getField("replication_mode")));
        structValue.setField("subnets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnets, this._getType().getField("subnets")));
        structValue.setField("transport_zone_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportZonePath, this._getType().getField("transport_zone_path")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
        structValue.setField("vlan_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vlanIds, this._getType().getField("vlan_ids")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.segment;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.segment.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Segment _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Segment(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Segment _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Segment(structValue);
    }

    /**
     * Builder class for {@link Segment}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_global_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private java.util.List<com.vmware.nsx_global_policy.model.PortAddressBindingEntry> addressBindings;
        private java.lang.String adminState;
        private com.vmware.nsx_global_policy.model.SegmentAdvancedConfig advancedConfig;
        private java.util.List<com.vmware.nsx_global_policy.model.BridgeProfileConfig> bridgeProfiles;
        private java.lang.String connectivityPath;
        private java.lang.String dhcpConfigPath;
        private java.lang.String domainName;
        private java.lang.Boolean evpnSegment;
        private java.lang.String evpnTenantConfigPath;
        private java.util.List<com.vmware.nsx_global_policy.model.SegmentExtraConfig> extraConfigs;
        private com.vmware.nsx_global_policy.model.FederationConnectivityConfig federationConfig;
        private com.vmware.nsx_global_policy.model.L2Extension l2Extension;
        private java.lang.String lsId;
        private java.lang.String macPoolId;
        private java.util.List<java.lang.String> metadataProxyPaths;
        private java.lang.Long overlayId;
        private java.lang.String replicationMode;
        private java.util.List<com.vmware.nsx_global_policy.model.SegmentSubnet> subnets;
        private java.lang.String transportZonePath;
        private java.lang.String type;
        private java.util.List<java.lang.String> vlanIds;

        /**
         * Constructor with parameters for the required properties of
         * {@link Segment}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in NSX+.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing who owns this object. This is
         * used in NSX+.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated their unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the NSX+
         * service, and path of the object on NSX+ service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entities in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
         * return a value of this class as a return value, the property will contain all
         * the properties defined in {@link
         * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         * Static address binding used for the Segment. This field is deprecated and will
         * be removed in a future release. Please use address_bindings in SegmentPort to
         * configure static bindings.
         *
         * @param addressBindings New value for the property.
         */
        public Builder setAddressBindings(java.util.List<com.vmware.nsx_global_policy.model.PortAddressBindingEntry> addressBindings) {
            this.addressBindings = addressBindings;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.Segment#ADMIN_STATE_UP}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.Segment#ADMIN_STATE_DOWN}</li> </ul> Admin
         * state represents desired state of segment. It does not reflect the state of
         * other logical entities connected/attached to the segment.
         *
         * @param adminState New value for the property.
         */
        public Builder setAdminState(java.lang.String adminState) {
            this.adminState = adminState;
            return this;
        }

        /**
         *
         *
         * @param advancedConfig New value for the property.
         */
        public Builder setAdvancedConfig(com.vmware.nsx_global_policy.model.SegmentAdvancedConfig advancedConfig) {
            this.advancedConfig = advancedConfig;
            return this;
        }

        /**
         * Multiple distinct L2 bridge profiles can be configured.
         *
         * @param bridgeProfiles New value for the property.
         */
        public Builder setBridgeProfiles(java.util.List<com.vmware.nsx_global_policy.model.BridgeProfileConfig> bridgeProfiles) {
            this.bridgeProfiles = bridgeProfiles;
            return this;
        }

        /**
         * Policy path to the connecting Tier-0 or Tier-1 or label of type Tier0. Valid
         * only for segments created under Infra. This field can only be used for overlay
         * segments. VLAN backed segments cannot have connectivity path set.
         *
         * @param connectivityPath New value for the property.
         */
        public Builder setConnectivityPath(java.lang.String connectivityPath) {
            this.connectivityPath = connectivityPath;
            return this;
        }

        /**
         * Policy path to DHCP server or relay configuration to use for all IPv4 & IPv6
         * subnets configured on this segment.
         *
         * @param dhcpConfigPath New value for the property.
         */
        public Builder setDhcpConfigPath(java.lang.String dhcpConfigPath) {
            this.dhcpConfigPath = dhcpConfigPath;
            return this;
        }

        /**
         * DNS domain name
         *
         * @param domainName New value for the property.
         */
        public Builder setDomainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Flag to indicate if the Segment is a Child-Segment of type EVPN.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param evpnSegment New value for the property.
         */
        public Builder setEvpnSegment(java.lang.Boolean evpnSegment) {
            this.evpnSegment = evpnSegment;
            return this;
        }

        /**
         * Policy path to the EvpnTenantConfig resource. Supported only for Route-Server
         * Evpn Mode. Supported only for Overlay Segments. This will be populated for both
         * Parent and Child segments participating in Evpn Route-Server Mode.
         *
         * @param evpnTenantConfigPath New value for the property.
         */
        public Builder setEvpnTenantConfigPath(java.lang.String evpnTenantConfigPath) {
            this.evpnTenantConfigPath = evpnTenantConfigPath;
            return this;
        }

        /**
         * This property could be used for vendor specific configuration in key value
         * string pairs, the setting in extra_configs will be automatically inheritted by
         * segment ports in the Segment.
         *
         * @param extraConfigs New value for the property.
         */
        public Builder setExtraConfigs(java.util.List<com.vmware.nsx_global_policy.model.SegmentExtraConfig> extraConfigs) {
            this.extraConfigs = extraConfigs;
            return this;
        }

        /**
         *
         *
         * @param federationConfig New value for the property.
         */
        public Builder setFederationConfig(com.vmware.nsx_global_policy.model.FederationConnectivityConfig federationConfig) {
            this.federationConfig = federationConfig;
            return this;
        }

        /**
         *
         *
         * @param l2Extension New value for the property.
         */
        public Builder setL2Extension(com.vmware.nsx_global_policy.model.L2Extension l2Extension) {
            this.l2Extension = l2Extension;
            return this;
        }

        /**
         * This property is deprecated. The property will continue to work as expected for
         * existing segments. The segments that are newly created with ls_id will be
         * ignored. Sepcify pre-creted logical switch id for Segment.
         *
         * @param lsId New value for the property.
         */
        public Builder setLsId(java.lang.String lsId) {
            this.lsId = lsId;
            return this;
        }

        /**
         * Mac pool id that associated with a Segment.
         *
         * @param macPoolId New value for the property.
         */
        public Builder setMacPoolId(java.lang.String macPoolId) {
            this.macPoolId = macPoolId;
            return this;
        }

        /**
         * Policy path to metadata proxy configuration. Multiple distinct MD proxies can be
         * configured.
         *
         * @param metadataProxyPaths New value for the property.
         */
        public Builder setMetadataProxyPaths(java.util.List<java.lang.String> metadataProxyPaths) {
            this.metadataProxyPaths = metadataProxyPaths;
            return this;
        }

        /**
         * Used for overlay connectivity of segments. The overlay_id should be allocated
         * from the pool as definied by enforcement-point. If not provided, it is
         * auto-allocated from the default pool on the enforcement-point. format: int32
         *
         * @param overlayId New value for the property.
         */
        public Builder setOverlayId(java.lang.Long overlayId) {
            this.overlayId = overlayId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.Segment#REPLICATION_MODE_MTEP}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.Segment#REPLICATION_MODE_SOURCE}</li>
         * </ul> If this field is not set for overlay segment, then the default of MTEP
         * will be used.
         *
         * @param replicationMode New value for the property.
         */
        public Builder setReplicationMode(java.lang.String replicationMode) {
            this.replicationMode = replicationMode;
            return this;
        }

        /**
         * Subnet configuration. Max 1 subnet
         *
         * @param subnets New value for the property.
         */
        public Builder setSubnets(java.util.List<com.vmware.nsx_global_policy.model.SegmentSubnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Policy path to the transport zone. Supported for VLAN backed segments as well as
         * Overlay Segments. - This field is required for VLAN backed Segments. - For
         * overlay Segments, it is auto assigned if only one transport zone exists in the
         * enforcement point. Default transport zone is auto assigned for overlay segments
         * if none specified.
         *
         * @param transportZonePath New value for the property.
         */
        public Builder setTransportZonePath(java.lang.String transportZonePath) {
            this.transportZonePath = transportZonePath;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.Segment#TYPE_ROUTED}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.Segment#TYPE_EXTENDED}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.Segment#TYPE_ROUTED_AND_EXTENDED}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.Segment#TYPE_DISCONNECTED}</li> </ul>
         * Segment type based on configuration.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * VLAN ids for a VLAN backed Segment. Can be a VLAN id or a range of VLAN ids
         * specified with '-' in between.
         *
         * @param vlanIds New value for the property.
         */
        public Builder setVlanIds(java.util.List<java.lang.String> vlanIds) {
            this.vlanIds = vlanIds;
            return this;
        }

        public Segment build() {
            Segment result = new Segment();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setAddressBindings(this.addressBindings);
            result.setAdminState(this.adminState);
            result.setAdvancedConfig(this.advancedConfig);
            result.setBridgeProfiles(this.bridgeProfiles);
            result.setConnectivityPath(this.connectivityPath);
            result.setDhcpConfigPath(this.dhcpConfigPath);
            result.setDomainName(this.domainName);
            result.setEvpnSegment(this.evpnSegment);
            result.setEvpnTenantConfigPath(this.evpnTenantConfigPath);
            result.setExtraConfigs(this.extraConfigs);
            result.setFederationConfig(this.federationConfig);
            result.setL2Extension(this.l2Extension);
            result.setLsId(this.lsId);
            result.setMacPoolId(this.macPoolId);
            result.setMetadataProxyPaths(this.metadataProxyPaths);
            result.setOverlayId(this.overlayId);
            result.setReplicationMode(this.replicationMode);
            result.setSubnets(this.subnets);
            result.setTransportZonePath(this.transportZonePath);
            result.setType(this.type);
            result.setVlanIds(this.vlanIds);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("address_bindings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.portAddressBindingEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("address_bindings",
                                                                                "addressBindings",
                                                                                "getAddressBindings",
                                                                                "setAddressBindings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("admin_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_state",
                                                                                "adminState",
                                                                                "getAdminState",
                                                                                "setAdminState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("advanced_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.segmentAdvancedConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("advanced_config",
                                                                                "advancedConfig",
                                                                                "getAdvancedConfig",
                                                                                "setAdvancedConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bridge_profiles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.bridgeProfileConfig; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bridge_profiles",
                                                                                "bridgeProfiles",
                                                                                "getBridgeProfiles",
                                                                                "setBridgeProfiles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connectivity_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connectivity_path",
                                                                                "connectivityPath",
                                                                                "getConnectivityPath",
                                                                                "setConnectivityPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_config_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_config_path",
                                                                                "dhcpConfigPath",
                                                                                "getDhcpConfigPath",
                                                                                "setDhcpConfigPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("domain_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_name",
                                                                                "domainName",
                                                                                "getDomainName",
                                                                                "setDomainName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("evpn_segment", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("evpn_segment",
                                                                                "evpnSegment",
                                                                                "getEvpnSegment",
                                                                                "setEvpnSegment");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("evpn_tenant_config_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("evpn_tenant_config_path",
                                                                                "evpnTenantConfigPath",
                                                                                "getEvpnTenantConfigPath",
                                                                                "setEvpnTenantConfigPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("extra_configs", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.segmentExtraConfig; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("extra_configs",
                                                                                "extraConfigs",
                                                                                "getExtraConfigs",
                                                                                "setExtraConfigs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("federation_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.federationConnectivityConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_config",
                                                                                "federationConfig",
                                                                                "getFederationConfig",
                                                                                "setFederationConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("l2_extension", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.l2Extension; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("l2_extension",
                                                                                "l2Extension",
                                                                                "getL2Extension",
                                                                                "setL2Extension");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ls_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ls_id",
                                                                                "lsId",
                                                                                "getLsId",
                                                                                "setLsId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_pool_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mac_pool_id",
                                                                                "macPoolId",
                                                                                "getMacPoolId",
                                                                                "setMacPoolId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("metadata_proxy_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("metadata_proxy_paths",
                                                                                "metadataProxyPaths",
                                                                                "getMetadataProxyPaths",
                                                                                "setMetadataProxyPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overlay_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overlay_id",
                                                                                "overlayId",
                                                                                "getOverlayId",
                                                                                "setOverlayId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("replication_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("replication_mode",
                                                                                "replicationMode",
                                                                                "getReplicationMode",
                                                                                "setReplicationMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.segmentSubnet; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnets",
                                                                                "subnets",
                                                                                "getSubnets",
                                                                                "setSubnets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_zone_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_zone_path",
                                                                                "transportZonePath",
                                                                                "getTransportZonePath",
                                                                                "setTransportZonePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vlan_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vlan_ids",
                                                                                "vlanIds",
                                                                                "getVlanIds",
                                                                                "setVlanIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.segment",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.Segment.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

