/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

public final class SwsecCounters implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long bpduFilterDrops;

    private java.lang.Long dhcpClientBlockIpv4Drops;

    private java.lang.Long dhcpClientBlockIpv6Drops;

    private java.lang.Long dhcpClientValidateIpv4Drops;

    private java.lang.Long dhcpServerBlockIpv4Drops;

    private java.lang.Long dhcpServerBlockIpv6Drops;

    private java.lang.Long ndParseErrors;

    private java.lang.Long raGuardDrops;

    private java.lang.Long rxArpPkts;

    private java.lang.Long rxIpv4Pkts;

    private java.lang.Long rxIpv6Pkts;

    private java.lang.Long rxNonIpPkts;

    private java.lang.Long rxRateLimitBcastDrops;

    private java.lang.Long rxRateLimitMcastDrops;

    private java.lang.Long spoofGuardArpDrops;

    private java.lang.Long spoofGuardIpv4Drops;

    private java.lang.Long spoofGuardIpv6Drops;

    private java.lang.Long spoofGuardNdDrops;

    private java.lang.Long spoofGuardNonIpDrops;

    private java.lang.Long txArpPkts;

    private java.lang.Long txGarpPkts;

    private java.lang.Long txIpv4Pkts;

    private java.lang.Long txIpv6Pkts;

    private java.lang.Long txNaPkts;

    private java.lang.Long txNonIpPkts;

    private java.lang.Long txNsPkts;

    private java.lang.Long txRateLimitBcastDrops;

    private java.lang.Long txRateLimitMcastDrops;

    private java.lang.Long txUnsolicitedNaPkts;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SwsecCounters() {
    }

    protected SwsecCounters(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of packets dropped by BPDU Filtering. When the BPDU Filter is enabled,
     * traffic to the configured BPDU destination MAC addresses format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBpduFilterDrops() {
        return this.bpduFilterDrops;
    }

    /**
     * Number of packets dropped by BPDU Filtering. When the BPDU Filter is enabled,
     * traffic to the configured BPDU destination MAC addresses format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bpduFilterDrops New value for the property.
     */
    public void setBpduFilterDrops(java.lang.Long bpduFilterDrops) {
        this.bpduFilterDrops = bpduFilterDrops;
    }

    /**
     * Number of IPv4 DHCP packets dropped by DHCP Client Block. DHCP Client Block
     * prevents a VM from acquiring DHCP IP address by blocking DHCP requests format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDhcpClientBlockIpv4Drops() {
        return this.dhcpClientBlockIpv4Drops;
    }

    /**
     * Number of IPv4 DHCP packets dropped by DHCP Client Block. DHCP Client Block
     * prevents a VM from acquiring DHCP IP address by blocking DHCP requests format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dhcpClientBlockIpv4Drops New value for the property.
     */
    public void setDhcpClientBlockIpv4Drops(java.lang.Long dhcpClientBlockIpv4Drops) {
        this.dhcpClientBlockIpv4Drops = dhcpClientBlockIpv4Drops;
    }

    /**
     * Number of DHCPv6 packets dropped by DHCP Client Block. DHCP Client Block
     * prevents a VM from acquiring DHCP IP address by blocking DHCP requests format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDhcpClientBlockIpv6Drops() {
        return this.dhcpClientBlockIpv6Drops;
    }

    /**
     * Number of DHCPv6 packets dropped by DHCP Client Block. DHCP Client Block
     * prevents a VM from acquiring DHCP IP address by blocking DHCP requests format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dhcpClientBlockIpv6Drops New value for the property.
     */
    public void setDhcpClientBlockIpv6Drops(java.lang.Long dhcpClientBlockIpv6Drops) {
        this.dhcpClientBlockIpv6Drops = dhcpClientBlockIpv6Drops;
    }

    /**
     * Number of IPv4 DHCP packets dropped because addresses in the payload were not
     * valid format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDhcpClientValidateIpv4Drops() {
        return this.dhcpClientValidateIpv4Drops;
    }

    /**
     * Number of IPv4 DHCP packets dropped because addresses in the payload were not
     * valid format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dhcpClientValidateIpv4Drops New value for the property.
     */
    public void setDhcpClientValidateIpv4Drops(java.lang.Long dhcpClientValidateIpv4Drops) {
        this.dhcpClientValidateIpv4Drops = dhcpClientValidateIpv4Drops;
    }

    /**
     * Number of IPv4 DHCP packets dropped by DHCP Server Block. DHCP Server Block
     * blocks traffic from a DHCP Server to a DHCP Client format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDhcpServerBlockIpv4Drops() {
        return this.dhcpServerBlockIpv4Drops;
    }

    /**
     * Number of IPv4 DHCP packets dropped by DHCP Server Block. DHCP Server Block
     * blocks traffic from a DHCP Server to a DHCP Client format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dhcpServerBlockIpv4Drops New value for the property.
     */
    public void setDhcpServerBlockIpv4Drops(java.lang.Long dhcpServerBlockIpv4Drops) {
        this.dhcpServerBlockIpv4Drops = dhcpServerBlockIpv4Drops;
    }

    /**
     * Number of DHCPv6 packets dropped by DHCP Server Block. DHCP Server Block blocks
     * traffic from a DHCP Server to a DHCP Client format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDhcpServerBlockIpv6Drops() {
        return this.dhcpServerBlockIpv6Drops;
    }

    /**
     * Number of DHCPv6 packets dropped by DHCP Server Block. DHCP Server Block blocks
     * traffic from a DHCP Server to a DHCP Client format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dhcpServerBlockIpv6Drops New value for the property.
     */
    public void setDhcpServerBlockIpv6Drops(java.lang.Long dhcpServerBlockIpv6Drops) {
        this.dhcpServerBlockIpv6Drops = dhcpServerBlockIpv6Drops;
    }

    /**
     * Number of IPv 6 Router Advertisement packets dropped by RA Guard. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNdParseErrors() {
        return this.ndParseErrors;
    }

    /**
     * Number of IPv 6 Router Advertisement packets dropped by RA Guard. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ndParseErrors New value for the property.
     */
    public void setNdParseErrors(java.lang.Long ndParseErrors) {
        this.ndParseErrors = ndParseErrors;
    }

    /**
     * Number of IPv6 Neighbor Discovery (ND) packets which were not correctly parsed
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRaGuardDrops() {
        return this.raGuardDrops;
    }

    /**
     * Number of IPv6 Neighbor Discovery (ND) packets which were not correctly parsed
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param raGuardDrops New value for the property.
     */
    public void setRaGuardDrops(java.lang.Long raGuardDrops) {
        this.raGuardDrops = raGuardDrops;
    }

    /**
     * Number of transmitted IPv6 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxArpPkts() {
        return this.rxArpPkts;
    }

    /**
     * Number of transmitted IPv6 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rxArpPkts New value for the property.
     */
    public void setRxArpPkts(java.lang.Long rxArpPkts) {
        this.rxArpPkts = rxArpPkts;
    }

    /**
     * Number of received IPv4 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxIpv4Pkts() {
        return this.rxIpv4Pkts;
    }

    /**
     * Number of received IPv4 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rxIpv4Pkts New value for the property.
     */
    public void setRxIpv4Pkts(java.lang.Long rxIpv4Pkts) {
        this.rxIpv4Pkts = rxIpv4Pkts;
    }

    /**
     * Number of received IPv6 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxIpv6Pkts() {
        return this.rxIpv6Pkts;
    }

    /**
     * Number of received IPv6 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rxIpv6Pkts New value for the property.
     */
    public void setRxIpv6Pkts(java.lang.Long rxIpv6Pkts) {
        this.rxIpv6Pkts = rxIpv6Pkts;
    }

    /**
     * Number of transmitted Gratuitous ARP (GARP) packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxNonIpPkts() {
        return this.rxNonIpPkts;
    }

    /**
     * Number of transmitted Gratuitous ARP (GARP) packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rxNonIpPkts New value for the property.
     */
    public void setRxNonIpPkts(java.lang.Long rxNonIpPkts) {
        this.rxNonIpPkts = rxNonIpPkts;
    }

    /**
     * Number of ingress packets dropped by broadcast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxRateLimitBcastDrops() {
        return this.rxRateLimitBcastDrops;
    }

    /**
     * Number of ingress packets dropped by broadcast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rxRateLimitBcastDrops New value for the property.
     */
    public void setRxRateLimitBcastDrops(java.lang.Long rxRateLimitBcastDrops) {
        this.rxRateLimitBcastDrops = rxRateLimitBcastDrops;
    }

    /**
     * Number of ingress packets dropped by multicast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxRateLimitMcastDrops() {
        return this.rxRateLimitMcastDrops;
    }

    /**
     * Number of ingress packets dropped by multicast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rxRateLimitMcastDrops New value for the property.
     */
    public void setRxRateLimitMcastDrops(java.lang.Long rxRateLimitMcastDrops) {
        this.rxRateLimitMcastDrops = rxRateLimitMcastDrops;
    }

    /**
     * Number of IPv6 packets dropped by Spoof Guard. SpoofGuard protects against IP
     * spoofing by maintaining a reference table of , VM names and IP addresses format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpoofGuardArpDrops() {
        return this.spoofGuardArpDrops;
    }

    /**
     * Number of IPv6 packets dropped by Spoof Guard. SpoofGuard protects against IP
     * spoofing by maintaining a reference table of , VM names and IP addresses format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param spoofGuardArpDrops New value for the property.
     */
    public void setSpoofGuardArpDrops(java.lang.Long spoofGuardArpDrops) {
        this.spoofGuardArpDrops = spoofGuardArpDrops;
    }

    /**
     * Number of IPv4 packets dropped by Spoof Guard. SpoofGuard protects against IP
     * spoofing by maintaining a reference table of , VM names and IP addresses format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpoofGuardIpv4Drops() {
        return this.spoofGuardIpv4Drops;
    }

    /**
     * Number of IPv4 packets dropped by Spoof Guard. SpoofGuard protects against IP
     * spoofing by maintaining a reference table of , VM names and IP addresses format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param spoofGuardIpv4Drops New value for the property.
     */
    public void setSpoofGuardIpv4Drops(java.lang.Long spoofGuardIpv4Drops) {
        this.spoofGuardIpv4Drops = spoofGuardIpv4Drops;
    }

    /**
     * Number of IPv6 Neighbor Discovery (ND) packets dropped by Spoof Guard.
     * SpoofGuard protects against ND Spoofing by filtering out ND packets whose
     * addresses, do not match the VM's address format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpoofGuardIpv6Drops() {
        return this.spoofGuardIpv6Drops;
    }

    /**
     * Number of IPv6 Neighbor Discovery (ND) packets dropped by Spoof Guard.
     * SpoofGuard protects against ND Spoofing by filtering out ND packets whose
     * addresses, do not match the VM's address format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param spoofGuardIpv6Drops New value for the property.
     */
    public void setSpoofGuardIpv6Drops(java.lang.Long spoofGuardIpv6Drops) {
        this.spoofGuardIpv6Drops = spoofGuardIpv6Drops;
    }

    /**
     * Number of ARP packets dropped by Spoof Guard. Spoof Guard protects against
     * malicious ARP spoofing attacks by keeping track of , MAC and IP addresses
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpoofGuardNdDrops() {
        return this.spoofGuardNdDrops;
    }

    /**
     * Number of ARP packets dropped by Spoof Guard. Spoof Guard protects against
     * malicious ARP spoofing attacks by keeping track of , MAC and IP addresses
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param spoofGuardNdDrops New value for the property.
     */
    public void setSpoofGuardNdDrops(java.lang.Long spoofGuardNdDrops) {
        this.spoofGuardNdDrops = spoofGuardNdDrops;
    }

    /**
     * Number of Non-IP packets dropped by Spoof Guard format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpoofGuardNonIpDrops() {
        return this.spoofGuardNonIpDrops;
    }

    /**
     * Number of Non-IP packets dropped by Spoof Guard format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param spoofGuardNonIpDrops New value for the property.
     */
    public void setSpoofGuardNonIpDrops(java.lang.Long spoofGuardNonIpDrops) {
        this.spoofGuardNonIpDrops = spoofGuardNonIpDrops;
    }

    /**
     * Number of received ARP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxArpPkts() {
        return this.txArpPkts;
    }

    /**
     * Number of received ARP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txArpPkts New value for the property.
     */
    public void setTxArpPkts(java.lang.Long txArpPkts) {
        this.txArpPkts = txArpPkts;
    }

    /**
     * Number of transmitted ARP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxGarpPkts() {
        return this.txGarpPkts;
    }

    /**
     * Number of transmitted ARP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txGarpPkts New value for the property.
     */
    public void setTxGarpPkts(java.lang.Long txGarpPkts) {
        this.txGarpPkts = txGarpPkts;
    }

    /**
     * Number of transmitted IPv4 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxIpv4Pkts() {
        return this.txIpv4Pkts;
    }

    /**
     * Number of transmitted IPv4 packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txIpv4Pkts New value for the property.
     */
    public void setTxIpv4Pkts(java.lang.Long txIpv4Pkts) {
        this.txIpv4Pkts = txIpv4Pkts;
    }

    /**
     * Number of received non-IP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxIpv6Pkts() {
        return this.txIpv6Pkts;
    }

    /**
     * Number of received non-IP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txIpv6Pkts New value for the property.
     */
    public void setTxIpv6Pkts(java.lang.Long txIpv6Pkts) {
        this.txIpv6Pkts = txIpv6Pkts;
    }

    /**
     * Number of IPv6 ND (Neighbor Discovery) NA (Neighbor Advertisement) packets
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxNaPkts() {
        return this.txNaPkts;
    }

    /**
     * Number of IPv6 ND (Neighbor Discovery) NA (Neighbor Advertisement) packets
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txNaPkts New value for the property.
     */
    public void setTxNaPkts(java.lang.Long txNaPkts) {
        this.txNaPkts = txNaPkts;
    }

    /**
     * Number of transmitted non-IP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxNonIpPkts() {
        return this.txNonIpPkts;
    }

    /**
     * Number of transmitted non-IP packets format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txNonIpPkts New value for the property.
     */
    public void setTxNonIpPkts(java.lang.Long txNonIpPkts) {
        this.txNonIpPkts = txNonIpPkts;
    }

    /**
     * Number of IPv6 ND (Neighbor Discovery) NS (Neighbor Solicitation) packets
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxNsPkts() {
        return this.txNsPkts;
    }

    /**
     * Number of IPv6 ND (Neighbor Discovery) NS (Neighbor Solicitation) packets
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txNsPkts New value for the property.
     */
    public void setTxNsPkts(java.lang.Long txNsPkts) {
        this.txNsPkts = txNsPkts;
    }

    /**
     * Number of egress packets dropped by broadcast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxRateLimitBcastDrops() {
        return this.txRateLimitBcastDrops;
    }

    /**
     * Number of egress packets dropped by broadcast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txRateLimitBcastDrops New value for the property.
     */
    public void setTxRateLimitBcastDrops(java.lang.Long txRateLimitBcastDrops) {
        this.txRateLimitBcastDrops = txRateLimitBcastDrops;
    }

    /**
     * Number of egress packets dropped by multicast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxRateLimitMcastDrops() {
        return this.txRateLimitMcastDrops;
    }

    /**
     * Number of egress packets dropped by multicast Rate Limiting format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txRateLimitMcastDrops New value for the property.
     */
    public void setTxRateLimitMcastDrops(java.lang.Long txRateLimitMcastDrops) {
        this.txRateLimitMcastDrops = txRateLimitMcastDrops;
    }

    /**
     * Number of IPv6 ND (Neighbor Discovery) NA (Neighbor Advertisement) packets
     * which, were unsolicited format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxUnsolicitedNaPkts() {
        return this.txUnsolicitedNaPkts;
    }

    /**
     * Number of IPv6 ND (Neighbor Discovery) NA (Neighbor Advertisement) packets
     * which, were unsolicited format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param txUnsolicitedNaPkts New value for the property.
     */
    public void setTxUnsolicitedNaPkts(java.lang.Long txUnsolicitedNaPkts) {
        this.txUnsolicitedNaPkts = txUnsolicitedNaPkts;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.swsecCounters;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("bpdu_filter_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bpduFilterDrops, this._getType().getField("bpdu_filter_drops")));
        structValue.setField("dhcp_client_block_ipv4_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpClientBlockIpv4Drops, this._getType().getField("dhcp_client_block_ipv4_drops")));
        structValue.setField("dhcp_client_block_ipv6_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpClientBlockIpv6Drops, this._getType().getField("dhcp_client_block_ipv6_drops")));
        structValue.setField("dhcp_client_validate_ipv4_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpClientValidateIpv4Drops, this._getType().getField("dhcp_client_validate_ipv4_drops")));
        structValue.setField("dhcp_server_block_ipv4_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpServerBlockIpv4Drops, this._getType().getField("dhcp_server_block_ipv4_drops")));
        structValue.setField("dhcp_server_block_ipv6_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpServerBlockIpv6Drops, this._getType().getField("dhcp_server_block_ipv6_drops")));
        structValue.setField("nd_parse_errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndParseErrors, this._getType().getField("nd_parse_errors")));
        structValue.setField("ra_guard_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.raGuardDrops, this._getType().getField("ra_guard_drops")));
        structValue.setField("rx_arp_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxArpPkts, this._getType().getField("rx_arp_pkts")));
        structValue.setField("rx_ipv4_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxIpv4Pkts, this._getType().getField("rx_ipv4_pkts")));
        structValue.setField("rx_ipv6_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxIpv6Pkts, this._getType().getField("rx_ipv6_pkts")));
        structValue.setField("rx_non_ip_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxNonIpPkts, this._getType().getField("rx_non_ip_pkts")));
        structValue.setField("rx_rate_limit_bcast_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxRateLimitBcastDrops, this._getType().getField("rx_rate_limit_bcast_drops")));
        structValue.setField("rx_rate_limit_mcast_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxRateLimitMcastDrops, this._getType().getField("rx_rate_limit_mcast_drops")));
        structValue.setField("spoof_guard_arp_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spoofGuardArpDrops, this._getType().getField("spoof_guard_arp_drops")));
        structValue.setField("spoof_guard_ipv4_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spoofGuardIpv4Drops, this._getType().getField("spoof_guard_ipv4_drops")));
        structValue.setField("spoof_guard_ipv6_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spoofGuardIpv6Drops, this._getType().getField("spoof_guard_ipv6_drops")));
        structValue.setField("spoof_guard_nd_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spoofGuardNdDrops, this._getType().getField("spoof_guard_nd_drops")));
        structValue.setField("spoof_guard_non_ip_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spoofGuardNonIpDrops, this._getType().getField("spoof_guard_non_ip_drops")));
        structValue.setField("tx_arp_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txArpPkts, this._getType().getField("tx_arp_pkts")));
        structValue.setField("tx_garp_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txGarpPkts, this._getType().getField("tx_garp_pkts")));
        structValue.setField("tx_ipv4_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txIpv4Pkts, this._getType().getField("tx_ipv4_pkts")));
        structValue.setField("tx_ipv6_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txIpv6Pkts, this._getType().getField("tx_ipv6_pkts")));
        structValue.setField("tx_na_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txNaPkts, this._getType().getField("tx_na_pkts")));
        structValue.setField("tx_non_ip_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txNonIpPkts, this._getType().getField("tx_non_ip_pkts")));
        structValue.setField("tx_ns_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txNsPkts, this._getType().getField("tx_ns_pkts")));
        structValue.setField("tx_rate_limit_bcast_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txRateLimitBcastDrops, this._getType().getField("tx_rate_limit_bcast_drops")));
        structValue.setField("tx_rate_limit_mcast_drops",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txRateLimitMcastDrops, this._getType().getField("tx_rate_limit_mcast_drops")));
        structValue.setField("tx_unsolicited_na_pkts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txUnsolicitedNaPkts, this._getType().getField("tx_unsolicited_na_pkts")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.swsecCounters;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.swsecCounters.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SwsecCounters _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SwsecCounters(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SwsecCounters _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SwsecCounters(structValue);
    }

    /**
     * Builder class for {@link SwsecCounters}.
     */
    public static final class Builder {
        private java.lang.Long bpduFilterDrops;
        private java.lang.Long dhcpClientBlockIpv4Drops;
        private java.lang.Long dhcpClientBlockIpv6Drops;
        private java.lang.Long dhcpClientValidateIpv4Drops;
        private java.lang.Long dhcpServerBlockIpv4Drops;
        private java.lang.Long dhcpServerBlockIpv6Drops;
        private java.lang.Long ndParseErrors;
        private java.lang.Long raGuardDrops;
        private java.lang.Long rxArpPkts;
        private java.lang.Long rxIpv4Pkts;
        private java.lang.Long rxIpv6Pkts;
        private java.lang.Long rxNonIpPkts;
        private java.lang.Long rxRateLimitBcastDrops;
        private java.lang.Long rxRateLimitMcastDrops;
        private java.lang.Long spoofGuardArpDrops;
        private java.lang.Long spoofGuardIpv4Drops;
        private java.lang.Long spoofGuardIpv6Drops;
        private java.lang.Long spoofGuardNdDrops;
        private java.lang.Long spoofGuardNonIpDrops;
        private java.lang.Long txArpPkts;
        private java.lang.Long txGarpPkts;
        private java.lang.Long txIpv4Pkts;
        private java.lang.Long txIpv6Pkts;
        private java.lang.Long txNaPkts;
        private java.lang.Long txNonIpPkts;
        private java.lang.Long txNsPkts;
        private java.lang.Long txRateLimitBcastDrops;
        private java.lang.Long txRateLimitMcastDrops;
        private java.lang.Long txUnsolicitedNaPkts;

        /**
         * Constructor with parameters for the required properties of
         * {@link SwsecCounters}.
         */
        public Builder() {
        }

        /**
         * Number of packets dropped by BPDU Filtering. When the BPDU Filter is enabled,
         * traffic to the configured BPDU destination MAC addresses format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bpduFilterDrops New value for the property.
         */
        public Builder setBpduFilterDrops(java.lang.Long bpduFilterDrops) {
            this.bpduFilterDrops = bpduFilterDrops;
            return this;
        }

        /**
         * Number of IPv4 DHCP packets dropped by DHCP Client Block. DHCP Client Block
         * prevents a VM from acquiring DHCP IP address by blocking DHCP requests format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dhcpClientBlockIpv4Drops New value for the property.
         */
        public Builder setDhcpClientBlockIpv4Drops(java.lang.Long dhcpClientBlockIpv4Drops) {
            this.dhcpClientBlockIpv4Drops = dhcpClientBlockIpv4Drops;
            return this;
        }

        /**
         * Number of DHCPv6 packets dropped by DHCP Client Block. DHCP Client Block
         * prevents a VM from acquiring DHCP IP address by blocking DHCP requests format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dhcpClientBlockIpv6Drops New value for the property.
         */
        public Builder setDhcpClientBlockIpv6Drops(java.lang.Long dhcpClientBlockIpv6Drops) {
            this.dhcpClientBlockIpv6Drops = dhcpClientBlockIpv6Drops;
            return this;
        }

        /**
         * Number of IPv4 DHCP packets dropped because addresses in the payload were not
         * valid format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dhcpClientValidateIpv4Drops New value for the property.
         */
        public Builder setDhcpClientValidateIpv4Drops(java.lang.Long dhcpClientValidateIpv4Drops) {
            this.dhcpClientValidateIpv4Drops = dhcpClientValidateIpv4Drops;
            return this;
        }

        /**
         * Number of IPv4 DHCP packets dropped by DHCP Server Block. DHCP Server Block
         * blocks traffic from a DHCP Server to a DHCP Client format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dhcpServerBlockIpv4Drops New value for the property.
         */
        public Builder setDhcpServerBlockIpv4Drops(java.lang.Long dhcpServerBlockIpv4Drops) {
            this.dhcpServerBlockIpv4Drops = dhcpServerBlockIpv4Drops;
            return this;
        }

        /**
         * Number of DHCPv6 packets dropped by DHCP Server Block. DHCP Server Block blocks
         * traffic from a DHCP Server to a DHCP Client format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dhcpServerBlockIpv6Drops New value for the property.
         */
        public Builder setDhcpServerBlockIpv6Drops(java.lang.Long dhcpServerBlockIpv6Drops) {
            this.dhcpServerBlockIpv6Drops = dhcpServerBlockIpv6Drops;
            return this;
        }

        /**
         * Number of IPv 6 Router Advertisement packets dropped by RA Guard. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ndParseErrors New value for the property.
         */
        public Builder setNdParseErrors(java.lang.Long ndParseErrors) {
            this.ndParseErrors = ndParseErrors;
            return this;
        }

        /**
         * Number of IPv6 Neighbor Discovery (ND) packets which were not correctly parsed
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param raGuardDrops New value for the property.
         */
        public Builder setRaGuardDrops(java.lang.Long raGuardDrops) {
            this.raGuardDrops = raGuardDrops;
            return this;
        }

        /**
         * Number of transmitted IPv6 packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rxArpPkts New value for the property.
         */
        public Builder setRxArpPkts(java.lang.Long rxArpPkts) {
            this.rxArpPkts = rxArpPkts;
            return this;
        }

        /**
         * Number of received IPv4 packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rxIpv4Pkts New value for the property.
         */
        public Builder setRxIpv4Pkts(java.lang.Long rxIpv4Pkts) {
            this.rxIpv4Pkts = rxIpv4Pkts;
            return this;
        }

        /**
         * Number of received IPv6 packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rxIpv6Pkts New value for the property.
         */
        public Builder setRxIpv6Pkts(java.lang.Long rxIpv6Pkts) {
            this.rxIpv6Pkts = rxIpv6Pkts;
            return this;
        }

        /**
         * Number of transmitted Gratuitous ARP (GARP) packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rxNonIpPkts New value for the property.
         */
        public Builder setRxNonIpPkts(java.lang.Long rxNonIpPkts) {
            this.rxNonIpPkts = rxNonIpPkts;
            return this;
        }

        /**
         * Number of ingress packets dropped by broadcast Rate Limiting format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rxRateLimitBcastDrops New value for the property.
         */
        public Builder setRxRateLimitBcastDrops(java.lang.Long rxRateLimitBcastDrops) {
            this.rxRateLimitBcastDrops = rxRateLimitBcastDrops;
            return this;
        }

        /**
         * Number of ingress packets dropped by multicast Rate Limiting format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rxRateLimitMcastDrops New value for the property.
         */
        public Builder setRxRateLimitMcastDrops(java.lang.Long rxRateLimitMcastDrops) {
            this.rxRateLimitMcastDrops = rxRateLimitMcastDrops;
            return this;
        }

        /**
         * Number of IPv6 packets dropped by Spoof Guard. SpoofGuard protects against IP
         * spoofing by maintaining a reference table of , VM names and IP addresses format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param spoofGuardArpDrops New value for the property.
         */
        public Builder setSpoofGuardArpDrops(java.lang.Long spoofGuardArpDrops) {
            this.spoofGuardArpDrops = spoofGuardArpDrops;
            return this;
        }

        /**
         * Number of IPv4 packets dropped by Spoof Guard. SpoofGuard protects against IP
         * spoofing by maintaining a reference table of , VM names and IP addresses format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param spoofGuardIpv4Drops New value for the property.
         */
        public Builder setSpoofGuardIpv4Drops(java.lang.Long spoofGuardIpv4Drops) {
            this.spoofGuardIpv4Drops = spoofGuardIpv4Drops;
            return this;
        }

        /**
         * Number of IPv6 Neighbor Discovery (ND) packets dropped by Spoof Guard.
         * SpoofGuard protects against ND Spoofing by filtering out ND packets whose
         * addresses, do not match the VM's address format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param spoofGuardIpv6Drops New value for the property.
         */
        public Builder setSpoofGuardIpv6Drops(java.lang.Long spoofGuardIpv6Drops) {
            this.spoofGuardIpv6Drops = spoofGuardIpv6Drops;
            return this;
        }

        /**
         * Number of ARP packets dropped by Spoof Guard. Spoof Guard protects against
         * malicious ARP spoofing attacks by keeping track of , MAC and IP addresses
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param spoofGuardNdDrops New value for the property.
         */
        public Builder setSpoofGuardNdDrops(java.lang.Long spoofGuardNdDrops) {
            this.spoofGuardNdDrops = spoofGuardNdDrops;
            return this;
        }

        /**
         * Number of Non-IP packets dropped by Spoof Guard format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param spoofGuardNonIpDrops New value for the property.
         */
        public Builder setSpoofGuardNonIpDrops(java.lang.Long spoofGuardNonIpDrops) {
            this.spoofGuardNonIpDrops = spoofGuardNonIpDrops;
            return this;
        }

        /**
         * Number of received ARP packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txArpPkts New value for the property.
         */
        public Builder setTxArpPkts(java.lang.Long txArpPkts) {
            this.txArpPkts = txArpPkts;
            return this;
        }

        /**
         * Number of transmitted ARP packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txGarpPkts New value for the property.
         */
        public Builder setTxGarpPkts(java.lang.Long txGarpPkts) {
            this.txGarpPkts = txGarpPkts;
            return this;
        }

        /**
         * Number of transmitted IPv4 packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txIpv4Pkts New value for the property.
         */
        public Builder setTxIpv4Pkts(java.lang.Long txIpv4Pkts) {
            this.txIpv4Pkts = txIpv4Pkts;
            return this;
        }

        /**
         * Number of received non-IP packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txIpv6Pkts New value for the property.
         */
        public Builder setTxIpv6Pkts(java.lang.Long txIpv6Pkts) {
            this.txIpv6Pkts = txIpv6Pkts;
            return this;
        }

        /**
         * Number of IPv6 ND (Neighbor Discovery) NA (Neighbor Advertisement) packets
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txNaPkts New value for the property.
         */
        public Builder setTxNaPkts(java.lang.Long txNaPkts) {
            this.txNaPkts = txNaPkts;
            return this;
        }

        /**
         * Number of transmitted non-IP packets format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txNonIpPkts New value for the property.
         */
        public Builder setTxNonIpPkts(java.lang.Long txNonIpPkts) {
            this.txNonIpPkts = txNonIpPkts;
            return this;
        }

        /**
         * Number of IPv6 ND (Neighbor Discovery) NS (Neighbor Solicitation) packets
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txNsPkts New value for the property.
         */
        public Builder setTxNsPkts(java.lang.Long txNsPkts) {
            this.txNsPkts = txNsPkts;
            return this;
        }

        /**
         * Number of egress packets dropped by broadcast Rate Limiting format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txRateLimitBcastDrops New value for the property.
         */
        public Builder setTxRateLimitBcastDrops(java.lang.Long txRateLimitBcastDrops) {
            this.txRateLimitBcastDrops = txRateLimitBcastDrops;
            return this;
        }

        /**
         * Number of egress packets dropped by multicast Rate Limiting format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txRateLimitMcastDrops New value for the property.
         */
        public Builder setTxRateLimitMcastDrops(java.lang.Long txRateLimitMcastDrops) {
            this.txRateLimitMcastDrops = txRateLimitMcastDrops;
            return this;
        }

        /**
         * Number of IPv6 ND (Neighbor Discovery) NA (Neighbor Advertisement) packets
         * which, were unsolicited format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param txUnsolicitedNaPkts New value for the property.
         */
        public Builder setTxUnsolicitedNaPkts(java.lang.Long txUnsolicitedNaPkts) {
            this.txUnsolicitedNaPkts = txUnsolicitedNaPkts;
            return this;
        }

        public SwsecCounters build() {
            SwsecCounters result = new SwsecCounters();
            result.setBpduFilterDrops(this.bpduFilterDrops);
            result.setDhcpClientBlockIpv4Drops(this.dhcpClientBlockIpv4Drops);
            result.setDhcpClientBlockIpv6Drops(this.dhcpClientBlockIpv6Drops);
            result.setDhcpClientValidateIpv4Drops(this.dhcpClientValidateIpv4Drops);
            result.setDhcpServerBlockIpv4Drops(this.dhcpServerBlockIpv4Drops);
            result.setDhcpServerBlockIpv6Drops(this.dhcpServerBlockIpv6Drops);
            result.setNdParseErrors(this.ndParseErrors);
            result.setRaGuardDrops(this.raGuardDrops);
            result.setRxArpPkts(this.rxArpPkts);
            result.setRxIpv4Pkts(this.rxIpv4Pkts);
            result.setRxIpv6Pkts(this.rxIpv6Pkts);
            result.setRxNonIpPkts(this.rxNonIpPkts);
            result.setRxRateLimitBcastDrops(this.rxRateLimitBcastDrops);
            result.setRxRateLimitMcastDrops(this.rxRateLimitMcastDrops);
            result.setSpoofGuardArpDrops(this.spoofGuardArpDrops);
            result.setSpoofGuardIpv4Drops(this.spoofGuardIpv4Drops);
            result.setSpoofGuardIpv6Drops(this.spoofGuardIpv6Drops);
            result.setSpoofGuardNdDrops(this.spoofGuardNdDrops);
            result.setSpoofGuardNonIpDrops(this.spoofGuardNonIpDrops);
            result.setTxArpPkts(this.txArpPkts);
            result.setTxGarpPkts(this.txGarpPkts);
            result.setTxIpv4Pkts(this.txIpv4Pkts);
            result.setTxIpv6Pkts(this.txIpv6Pkts);
            result.setTxNaPkts(this.txNaPkts);
            result.setTxNonIpPkts(this.txNonIpPkts);
            result.setTxNsPkts(this.txNsPkts);
            result.setTxRateLimitBcastDrops(this.txRateLimitBcastDrops);
            result.setTxRateLimitMcastDrops(this.txRateLimitMcastDrops);
            result.setTxUnsolicitedNaPkts(this.txUnsolicitedNaPkts);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("bpdu_filter_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bpdu_filter_drops",
                                                                                "bpduFilterDrops",
                                                                                "getBpduFilterDrops",
                                                                                "setBpduFilterDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_client_block_ipv4_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_client_block_ipv4_drops",
                                                                                "dhcpClientBlockIpv4Drops",
                                                                                "getDhcpClientBlockIpv4Drops",
                                                                                "setDhcpClientBlockIpv4Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_client_block_ipv6_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_client_block_ipv6_drops",
                                                                                "dhcpClientBlockIpv6Drops",
                                                                                "getDhcpClientBlockIpv6Drops",
                                                                                "setDhcpClientBlockIpv6Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_client_validate_ipv4_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_client_validate_ipv4_drops",
                                                                                "dhcpClientValidateIpv4Drops",
                                                                                "getDhcpClientValidateIpv4Drops",
                                                                                "setDhcpClientValidateIpv4Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_server_block_ipv4_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_server_block_ipv4_drops",
                                                                                "dhcpServerBlockIpv4Drops",
                                                                                "getDhcpServerBlockIpv4Drops",
                                                                                "setDhcpServerBlockIpv4Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_server_block_ipv6_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_server_block_ipv6_drops",
                                                                                "dhcpServerBlockIpv6Drops",
                                                                                "getDhcpServerBlockIpv6Drops",
                                                                                "setDhcpServerBlockIpv6Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nd_parse_errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nd_parse_errors",
                                                                                "ndParseErrors",
                                                                                "getNdParseErrors",
                                                                                "setNdParseErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ra_guard_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ra_guard_drops",
                                                                                "raGuardDrops",
                                                                                "getRaGuardDrops",
                                                                                "setRaGuardDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_arp_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_arp_pkts",
                                                                                "rxArpPkts",
                                                                                "getRxArpPkts",
                                                                                "setRxArpPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_ipv4_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_ipv4_pkts",
                                                                                "rxIpv4Pkts",
                                                                                "getRxIpv4Pkts",
                                                                                "setRxIpv4Pkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_ipv6_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_ipv6_pkts",
                                                                                "rxIpv6Pkts",
                                                                                "getRxIpv6Pkts",
                                                                                "setRxIpv6Pkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_non_ip_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_non_ip_pkts",
                                                                                "rxNonIpPkts",
                                                                                "getRxNonIpPkts",
                                                                                "setRxNonIpPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_rate_limit_bcast_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_rate_limit_bcast_drops",
                                                                                "rxRateLimitBcastDrops",
                                                                                "getRxRateLimitBcastDrops",
                                                                                "setRxRateLimitBcastDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_rate_limit_mcast_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_rate_limit_mcast_drops",
                                                                                "rxRateLimitMcastDrops",
                                                                                "getRxRateLimitMcastDrops",
                                                                                "setRxRateLimitMcastDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("spoof_guard_arp_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("spoof_guard_arp_drops",
                                                                                "spoofGuardArpDrops",
                                                                                "getSpoofGuardArpDrops",
                                                                                "setSpoofGuardArpDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("spoof_guard_ipv4_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("spoof_guard_ipv4_drops",
                                                                                "spoofGuardIpv4Drops",
                                                                                "getSpoofGuardIpv4Drops",
                                                                                "setSpoofGuardIpv4Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("spoof_guard_ipv6_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("spoof_guard_ipv6_drops",
                                                                                "spoofGuardIpv6Drops",
                                                                                "getSpoofGuardIpv6Drops",
                                                                                "setSpoofGuardIpv6Drops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("spoof_guard_nd_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("spoof_guard_nd_drops",
                                                                                "spoofGuardNdDrops",
                                                                                "getSpoofGuardNdDrops",
                                                                                "setSpoofGuardNdDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("spoof_guard_non_ip_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("spoof_guard_non_ip_drops",
                                                                                "spoofGuardNonIpDrops",
                                                                                "getSpoofGuardNonIpDrops",
                                                                                "setSpoofGuardNonIpDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_arp_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_arp_pkts",
                                                                                "txArpPkts",
                                                                                "getTxArpPkts",
                                                                                "setTxArpPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_garp_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_garp_pkts",
                                                                                "txGarpPkts",
                                                                                "getTxGarpPkts",
                                                                                "setTxGarpPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_ipv4_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_ipv4_pkts",
                                                                                "txIpv4Pkts",
                                                                                "getTxIpv4Pkts",
                                                                                "setTxIpv4Pkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_ipv6_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_ipv6_pkts",
                                                                                "txIpv6Pkts",
                                                                                "getTxIpv6Pkts",
                                                                                "setTxIpv6Pkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_na_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_na_pkts",
                                                                                "txNaPkts",
                                                                                "getTxNaPkts",
                                                                                "setTxNaPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_non_ip_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_non_ip_pkts",
                                                                                "txNonIpPkts",
                                                                                "getTxNonIpPkts",
                                                                                "setTxNonIpPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_ns_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_ns_pkts",
                                                                                "txNsPkts",
                                                                                "getTxNsPkts",
                                                                                "setTxNsPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_rate_limit_bcast_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_rate_limit_bcast_drops",
                                                                                "txRateLimitBcastDrops",
                                                                                "getTxRateLimitBcastDrops",
                                                                                "setTxRateLimitBcastDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_rate_limit_mcast_drops", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_rate_limit_mcast_drops",
                                                                                "txRateLimitMcastDrops",
                                                                                "getTxRateLimitMcastDrops",
                                                                                "setTxRateLimitMcastDrops");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_unsolicited_na_pkts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_unsolicited_na_pkts",
                                                                                "txUnsolicitedNaPkts",
                                                                                "getTxUnsolicitedNaPkts",
                                                                                "setTxUnsolicitedNaPkts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.swsec_counters",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.SwsecCounters.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

