/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.ui_views.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.ui_views;

public interface Widgetconfigurations extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.ui_views.WidgetconfigurationsTypes {

    /**
     * Creates a new Widget Configuration and adds it to the specified view. Supported
     * resource_types are LabelValueConfiguration, DonutConfiguration,
     * GridConfiguration, StatsConfiguration, MultiWidgetConfiguration,
     * GraphConfiguration and ContainerConfiguration. Note: Expressions should be given
     * in a single line. If an expression spans multiple lines, then form the
     * expression in a single line. For label-value pairs, expressions are evaluated as
     * follows: a. First, render configurations are evaluated in their order of
     * appearance in the widget config. The 'field' is evaluated at the end. b. Second,
     * when render configuration is provided then the order of evaluation is 1. If
     * expressions provided in 'condition' and 'display value' are well-formed and free
     * of runtime-errors such as 'null pointers' and evaluates to 'true'; Then
     * remaining render configurations are not evaluated, and the current render
     * configuration's 'display value' is taken as the final value. 2. If expression
     * provided in 'condition' of render configuration is false, then next render
     * configuration is evaluated. 3. Finally, 'field' is evaluated only when every
     * render configuration evaluates to false and no error occurs during steps 1 and 2
     * above. If an error occurs during evaluation of render configuration, then an
     * error message is shown. The display value corresponding to that label is not
     * shown and evaluation of the remaining render configurations continues to collect
     * and show all the error messages (marked with the 'Label' for identification) as
     * 'Error_Messages: {}'. If during evaluation of expressions for any label-value
     * pair an error occurs, then it is marked with error. The errors are shown in the
     * report, along with the label value pairs that are error-free. Important: For
     * elements that take expressions, strings should be provided by escaping them with
     * a back-slash. These elements are - condition, field, tooltip text and
     * render_configuration's display_value.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param viewId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @return com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure create(java.lang.String viewId, com.vmware.vapi.bindings.Structure widgetConfiguration);

    /**
     * Creates a new Widget Configuration and adds it to the specified view. Supported
     * resource_types are LabelValueConfiguration, DonutConfiguration,
     * GridConfiguration, StatsConfiguration, MultiWidgetConfiguration,
     * GraphConfiguration and ContainerConfiguration. Note: Expressions should be given
     * in a single line. If an expression spans multiple lines, then form the
     * expression in a single line. For label-value pairs, expressions are evaluated as
     * follows: a. First, render configurations are evaluated in their order of
     * appearance in the widget config. The 'field' is evaluated at the end. b. Second,
     * when render configuration is provided then the order of evaluation is 1. If
     * expressions provided in 'condition' and 'display value' are well-formed and free
     * of runtime-errors such as 'null pointers' and evaluates to 'true'; Then
     * remaining render configurations are not evaluated, and the current render
     * configuration's 'display value' is taken as the final value. 2. If expression
     * provided in 'condition' of render configuration is false, then next render
     * configuration is evaluated. 3. Finally, 'field' is evaluated only when every
     * render configuration evaluates to false and no error occurs during steps 1 and 2
     * above. If an error occurs during evaluation of render configuration, then an
     * error message is shown. The display value corresponding to that label is not
     * shown and evaluation of the remaining render configurations continues to collect
     * and show all the error messages (marked with the 'Label' for identification) as
     * 'Error_Messages: {}'. If during evaluation of expressions for any label-value
     * pair an error occurs, then it is marked with error. The errors are shown in the
     * report, along with the label value pairs that are error-free. Important: For
     * elements that take expressions, strings should be provided by escaping them with
     * a back-slash. These elements are - condition, field, tooltip text and
     * render_configuration's display_value.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param viewId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure create(java.lang.String viewId, com.vmware.vapi.bindings.Structure widgetConfiguration, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new Widget Configuration and adds it to the specified view. Supported
     * resource_types are LabelValueConfiguration, DonutConfiguration,
     * GridConfiguration, StatsConfiguration, MultiWidgetConfiguration,
     * GraphConfiguration and ContainerConfiguration. Note: Expressions should be given
     * in a single line. If an expression spans multiple lines, then form the
     * expression in a single line. For label-value pairs, expressions are evaluated as
     * follows: a. First, render configurations are evaluated in their order of
     * appearance in the widget config. The 'field' is evaluated at the end. b. Second,
     * when render configuration is provided then the order of evaluation is 1. If
     * expressions provided in 'condition' and 'display value' are well-formed and free
     * of runtime-errors such as 'null pointers' and evaluates to 'true'; Then
     * remaining render configurations are not evaluated, and the current render
     * configuration's 'display value' is taken as the final value. 2. If expression
     * provided in 'condition' of render configuration is false, then next render
     * configuration is evaluated. 3. Finally, 'field' is evaluated only when every
     * render configuration evaluates to false and no error occurs during steps 1 and 2
     * above. If an error occurs during evaluation of render configuration, then an
     * error message is shown. The display value corresponding to that label is not
     * shown and evaluation of the remaining render configurations continues to collect
     * and show all the error messages (marked with the 'Label' for identification) as
     * 'Error_Messages: {}'. If during evaluation of expressions for any label-value
     * pair an error occurs, then it is marked with error. The errors are shown in the
     * report, along with the label value pairs that are error-free. Important: For
     * elements that take expressions, strings should be provided by escaping them with
     * a back-slash. These elements are - condition, field, tooltip text and
     * render_configuration's display_value.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String viewId, com.vmware.vapi.bindings.Structure widgetConfiguration, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Creates a new Widget Configuration and adds it to the specified view. Supported
     * resource_types are LabelValueConfiguration, DonutConfiguration,
     * GridConfiguration, StatsConfiguration, MultiWidgetConfiguration,
     * GraphConfiguration and ContainerConfiguration. Note: Expressions should be given
     * in a single line. If an expression spans multiple lines, then form the
     * expression in a single line. For label-value pairs, expressions are evaluated as
     * follows: a. First, render configurations are evaluated in their order of
     * appearance in the widget config. The 'field' is evaluated at the end. b. Second,
     * when render configuration is provided then the order of evaluation is 1. If
     * expressions provided in 'condition' and 'display value' are well-formed and free
     * of runtime-errors such as 'null pointers' and evaluates to 'true'; Then
     * remaining render configurations are not evaluated, and the current render
     * configuration's 'display value' is taken as the final value. 2. If expression
     * provided in 'condition' of render configuration is false, then next render
     * configuration is evaluated. 3. Finally, 'field' is evaluated only when every
     * render configuration evaluates to false and no error occurs during steps 1 and 2
     * above. If an error occurs during evaluation of render configuration, then an
     * error message is shown. The display value corresponding to that label is not
     * shown and evaluation of the remaining render configurations continues to collect
     * and show all the error messages (marked with the 'Label' for identification) as
     * 'Error_Messages: {}'. If during evaluation of expressions for any label-value
     * pair an error occurs, then it is marked with error. The errors are shown in the
     * report, along with the label value pairs that are error-free. Important: For
     * elements that take expressions, strings should be provided by escaping them with
     * a back-slash. These elements are - condition, field, tooltip text and
     * render_configuration's display_value.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String viewId, com.vmware.vapi.bindings.Structure widgetConfiguration, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Detaches widget from a given view. If the widget is no longer part of any view,
     * then it will be purged.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String viewId, java.lang.String widgetconfigurationId);

    /**
     * Detaches widget from a given view. If the widget is no longer part of any view,
     * then it will be purged.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Detaches widget from a given view. If the widget is no longer part of any view,
     * then it will be purged.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Detaches widget from a given view. If the widget is no longer part of any view,
     * then it will be purged.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If no query params are specified then all the Widget Configurations of the
     * specified view are returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param viewId (required)
     * @param container Id of the container (optional)
     * @param widgetIds Ids of the WidgetConfigurations (optional)
     * @return com.vmware.nsx_global_policy.model.WidgetConfigurationList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.WidgetConfigurationList get(java.lang.String viewId, java.lang.String container, java.lang.String widgetIds);

    /**
     * If no query params are specified then all the Widget Configurations of the
     * specified view are returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param viewId (required)
     * @param container Id of the container (optional)
     * @param widgetIds Ids of the WidgetConfigurations (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.WidgetConfigurationList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.WidgetConfigurationList get(java.lang.String viewId, java.lang.String container, java.lang.String widgetIds, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If no query params are specified then all the Widget Configurations of the
     * specified view are returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfigurationList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param container Id of the container (optional)
     * @param widgetIds Ids of the WidgetConfigurations (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String viewId, java.lang.String container, java.lang.String widgetIds, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.WidgetConfigurationList> asyncCallback);

    /**
     * If no query params are specified then all the Widget Configurations of the
     * specified view are returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfigurationList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param container Id of the container (optional)
     * @param widgetIds Ids of the WidgetConfigurations (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String viewId, java.lang.String container, java.lang.String widgetIds, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.WidgetConfigurationList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns Information about a specific Widget Configuration.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @return com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure get0(java.lang.String viewId, java.lang.String widgetconfigurationId);

    /**
     * Returns Information about a specific Widget Configuration.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure get0(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns Information about a specific Widget Configuration.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get0(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Returns Information about a specific Widget Configuration.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get0(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates the widget at the given view. If the widget is referenced by other
     * views, then the widget will be updated in all the views that it is part of.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @return com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.Structure widgetConfiguration);

    /**
     * Updates the widget at the given view. If the widget is referenced by other
     * views, then the widget will be updated in all the views that it is part of.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.Structure widgetConfiguration, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates the widget at the given view. If the widget is referenced by other
     * views, then the widget will be updated in all the views that it is part of.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.Structure widgetConfiguration, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Updates the widget at the given view. If the widget is referenced by other
     * views, then the widget will be updated in all the views that it is part of.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.WidgetConfiguration
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param viewId (required)
     * @param widgetconfigurationId (required)
     * @param widgetConfiguration (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String viewId, java.lang.String widgetconfigurationId, com.vmware.vapi.bindings.Structure widgetConfiguration, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
