/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface LogicalSwitches extends com.vmware.vapi.bindings.Service, com.vmware.nsx.LogicalSwitchesTypes {

    /**
     * Creates a new logical switch. The request must include the transport_zone_id,
     * display_name, and admin_state (UP or DOWN). The replication_mode (MTEP or
     * SOURCE) is required for overlay logical switches, but not for VLAN-based logical
     * switches. A vlan needs to be provided for VLAN-based logical switches. <br/>
     * This api is now deprecated. Please use new api -/infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalSwitch (required)
     * @return com.vmware.nsx.model.LogicalSwitch
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitch create(com.vmware.nsx.model.LogicalSwitch logicalSwitch);

    /**
     * Creates a new logical switch. The request must include the transport_zone_id,
     * display_name, and admin_state (UP or DOWN). The replication_mode (MTEP or
     * SOURCE) is required for overlay logical switches, but not for VLAN-based logical
     * switches. A vlan needs to be provided for VLAN-based logical switches. <br/>
     * This api is now deprecated. Please use new api -/infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalSwitch (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalSwitch
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitch create(com.vmware.nsx.model.LogicalSwitch logicalSwitch, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new logical switch. The request must include the transport_zone_id,
     * display_name, and admin_state (UP or DOWN). The replication_mode (MTEP or
     * SOURCE) is required for overlay logical switches, but not for VLAN-based logical
     * switches. A vlan needs to be provided for VLAN-based logical switches. <br/>
     * This api is now deprecated. Please use new api -/infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitch
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalSwitch (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.LogicalSwitch logicalSwitch, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitch> asyncCallback);

    /**
     * Creates a new logical switch. The request must include the transport_zone_id,
     * display_name, and admin_state (UP or DOWN). The replication_mode (MTEP or
     * SOURCE) is required for overlay logical switches, but not for VLAN-based logical
     * switches. A vlan needs to be provided for VLAN-based logical switches. <br/>
     * This api is now deprecated. Please use new api -/infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitch
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalSwitch (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.LogicalSwitch logicalSwitch, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitch> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Removes a logical switch from the associated overlay or VLAN transport zone. By
     * default, a logical switch cannot be deleted if there are logical ports on the
     * switch, or it is added to a NSGroup. Cascade option can be used to delete all
     * ports and the logical switch. Detach option can be used to delete the logical
     * switch forcibly. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lswitchId (required)
     * @param cascade Delete a Logical Switch and all the logical ports in it, if none of the logical
     * ports have any attachment. (optional, default to false)
     * @param detach Force delete a logical switch (optional, default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String lswitchId, java.lang.Boolean cascade, java.lang.Boolean detach);

    /**
     * Removes a logical switch from the associated overlay or VLAN transport zone. By
     * default, a logical switch cannot be deleted if there are logical ports on the
     * switch, or it is added to a NSGroup. Cascade option can be used to delete all
     * ports and the logical switch. Detach option can be used to delete the logical
     * switch forcibly. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lswitchId (required)
     * @param cascade Delete a Logical Switch and all the logical ports in it, if none of the logical
     * ports have any attachment. (optional, default to false)
     * @param detach Force delete a logical switch (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String lswitchId, java.lang.Boolean cascade, java.lang.Boolean detach, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Removes a logical switch from the associated overlay or VLAN transport zone. By
     * default, a logical switch cannot be deleted if there are logical ports on the
     * switch, or it is added to a NSGroup. Cascade option can be used to delete all
     * ports and the logical switch. Detach option can be used to delete the logical
     * switch forcibly. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param cascade Delete a Logical Switch and all the logical ports in it, if none of the logical
     * ports have any attachment. (optional, default to false)
     * @param detach Force delete a logical switch (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String lswitchId, java.lang.Boolean cascade, java.lang.Boolean detach, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Removes a logical switch from the associated overlay or VLAN transport zone. By
     * default, a logical switch cannot be deleted if there are logical ports on the
     * switch, or it is added to a NSGroup. Cascade option can be used to delete all
     * ports and the logical switch. Detach option can be used to delete the logical
     * switch forcibly. <br/> This api is now deprecated. Please use new api -
     * /infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param cascade Delete a Logical Switch and all the logical ports in it, if none of the logical
     * ports have any attachment. (optional, default to false)
     * @param detach Force delete a logical switch (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String lswitchId, java.lang.Boolean cascade, java.lang.Boolean detach, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified logical switch Id. <br/> This api is now
     * deprecated. Please use new api - /infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lswitchId (required)
     * @return com.vmware.nsx.model.LogicalSwitch
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitch get(java.lang.String lswitchId);

    /**
     * Returns information about the specified logical switch Id. <br/> This api is now
     * deprecated. Please use new api - /infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lswitchId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalSwitch
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitch get(java.lang.String lswitchId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified logical switch Id. <br/> This api is now
     * deprecated. Please use new api - /infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitch
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String lswitchId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitch> asyncCallback);

    /**
     * Returns information about the specified logical switch Id. <br/> This api is now
     * deprecated. Please use new api - /infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitch
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String lswitchId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitch> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all configured logical switches. <br/> This api is now
     * deprecated. Please use new api - /infra/segments
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @return com.vmware.nsx.model.LogicalSwitchListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitchListResult list(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni);

    /**
     * Returns information about all configured logical switches. <br/> This api is now
     * deprecated. Please use new api - /infra/segments
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalSwitchListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitchListResult list(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all configured logical switches. <br/> This api is now
     * deprecated. Please use new api - /infra/segments
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitchListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitchListResult> asyncCallback);

    /**
     * Returns information about all configured logical switches. <br/> This api is now
     * deprecated. Please use new api - /infra/segments
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitchListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical switch. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchType Logical Switch type (optional)
     * @param switchingProfileId Switching Profile identifier (optional)
     * @param transportType Mode of transport supported in the transport zone for this logical switch
     * (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param uplinkTeamingPolicyName The logical switch's uplink teaming policy name (optional)
     * @param vlan Virtual Local Area Network Identifier (optional)
     * @param vni VNI of the OVERLAY LogicalSwitch(es) to return. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchType, java.lang.String switchingProfileId, java.lang.String transportType, java.lang.String transportZoneId, java.lang.String uplinkTeamingPolicyName, java.lang.Long vlan, java.lang.Long vni, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitchListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies attributes of an existing logical switch. Modifiable attributes include
     * admin_state, replication_mode, switching_profile_ids and VLAN spec. You cannot
     * modify the original transport_zone_id. <br/> This api is now deprecated. Please
     * use new api - PATCH /infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lswitchId (required)
     * @param logicalSwitch (required)
     * @return com.vmware.nsx.model.LogicalSwitch
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitch update(java.lang.String lswitchId, com.vmware.nsx.model.LogicalSwitch logicalSwitch);

    /**
     * Modifies attributes of an existing logical switch. Modifiable attributes include
     * admin_state, replication_mode, switching_profile_ids and VLAN spec. You cannot
     * modify the original transport_zone_id. <br/> This api is now deprecated. Please
     * use new api - PATCH /infra/segments/<segment-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lswitchId (required)
     * @param logicalSwitch (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalSwitch
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalSwitch update(java.lang.String lswitchId, com.vmware.nsx.model.LogicalSwitch logicalSwitch, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies attributes of an existing logical switch. Modifiable attributes include
     * admin_state, replication_mode, switching_profile_ids and VLAN spec. You cannot
     * modify the original transport_zone_id. <br/> This api is now deprecated. Please
     * use new api - PATCH /infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitch
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param logicalSwitch (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String lswitchId, com.vmware.nsx.model.LogicalSwitch logicalSwitch, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitch> asyncCallback);

    /**
     * Modifies attributes of an existing logical switch. Modifiable attributes include
     * admin_state, replication_mode, switching_profile_ids and VLAN spec. You cannot
     * modify the original transport_zone_id. <br/> This api is now deprecated. Please
     * use new api - PATCH /infra/segments/<segment-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitch
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param logicalSwitch (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String lswitchId, com.vmware.nsx.model.LogicalSwitch logicalSwitch, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitch> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
