/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.cluster.restore.
 * Used by client-side stubs.
 */

package com.vmware.nsx.cluster.restore;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx.cluster.restore.StatusTypes {

    /**
     * Returns status information for the specified NSX cluster restore request.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param restoreComponent (optional, default to LOCAL_MANAGER)
     * @return com.vmware.nsx.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterRestoreStatus get(java.lang.String restoreComponent);

    /**
     * Returns status information for the specified NSX cluster restore request.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param restoreComponent (optional, default to LOCAL_MANAGER)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterRestoreStatus get(java.lang.String restoreComponent, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns status information for the specified NSX cluster restore request.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param restoreComponent (optional, default to LOCAL_MANAGER)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String restoreComponent, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterRestoreStatus> asyncCallback);

    /**
     * Returns status information for the specified NSX cluster restore request.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param restoreComponent (optional, default to LOCAL_MANAGER)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String restoreComponent, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterRestoreStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
