/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.directory.domains.
 * Used by client-side stubs.
 */

package com.vmware.nsx.directory.domains;

public interface OrgUnits extends com.vmware.vapi.bindings.Service, com.vmware.nsx.directory.domains.OrgUnitsTypes {

    /**
     * Fetch all organization units for a Directory domain. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/org-units
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @return com.vmware.nsx.model.DirectoryOrgUnitListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryOrgUnitListResults create(java.lang.String domainId);

    /**
     * Fetch all organization units for a Directory domain. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/org-units
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DirectoryOrgUnitListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryOrgUnitListResults create(java.lang.String domainId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Fetch all organization units for a Directory domain. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/org-units
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryOrgUnitListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String domainId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryOrgUnitListResults> asyncCallback);

    /**
     * Fetch all organization units for a Directory domain. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/org-units
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryOrgUnitListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String domainId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryOrgUnitListResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
