/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.dns.forwarders.
 * Used by client-side stubs.
 */

package com.vmware.nsx.dns.forwarders;

public interface FailedQueries extends com.vmware.vapi.bindings.Service, com.vmware.nsx.dns.forwarders.FailedQueriesTypes {

    /**
     * Return the given count of recent failed DNS queries from DNS forwarder. Since
     * the DNS forwarder is running in Acitve/Standby HA mode on transport nodes, the
     * given count of queries will be returned from each nodes. Hence the total queries
     * returned could be doubled. If no count is specified, 100 recent failed queries
     * are returned. If the recent failures is less than the given count, all the
     * failures will be returned. The maximum count is 1,000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param forwarderId (required)
     * @param count The count of the failed DNS queries (optional, default to 100)
     * @return com.vmware.nsx.model.DnsFailedQueries
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.DnsFailedQueries get(java.lang.String forwarderId, java.lang.Long count);

    /**
     * Return the given count of recent failed DNS queries from DNS forwarder. Since
     * the DNS forwarder is running in Acitve/Standby HA mode on transport nodes, the
     * given count of queries will be returned from each nodes. Hence the total queries
     * returned could be doubled. If no count is specified, 100 recent failed queries
     * are returned. If the recent failures is less than the given count, all the
     * failures will be returned. The maximum count is 1,000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param forwarderId (required)
     * @param count The count of the failed DNS queries (optional, default to 100)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DnsFailedQueries
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.DnsFailedQueries get(java.lang.String forwarderId, java.lang.Long count, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return the given count of recent failed DNS queries from DNS forwarder. Since
     * the DNS forwarder is running in Acitve/Standby HA mode on transport nodes, the
     * given count of queries will be returned from each nodes. Hence the total queries
     * returned could be doubled. If no count is specified, 100 recent failed queries
     * are returned. If the recent failures is less than the given count, all the
     * failures will be returned. The maximum count is 1,000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DnsFailedQueries
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param forwarderId (required)
     * @param count The count of the failed DNS queries (optional, default to 100)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String forwarderId, java.lang.Long count, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DnsFailedQueries> asyncCallback);

    /**
     * Return the given count of recent failed DNS queries from DNS forwarder. Since
     * the DNS forwarder is running in Acitve/Standby HA mode on transport nodes, the
     * given count of queries will be returned from each nodes. Hence the total queries
     * returned could be doubled. If no count is specified, 100 recent failed queries
     * are returned. If the recent failures is less than the given count, all the
     * failures will be returned. The maximum count is 1,000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DnsFailedQueries
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param forwarderId (required)
     * @param count The count of the failed DNS queries (optional, default to 100)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String forwarderId, java.lang.Long count, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DnsFailedQueries> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
