/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.fabric.
 * Used by client-side stubs.
 */

package com.vmware.nsx.fabric;

public interface Vifs extends com.vmware.vapi.bindings.Service, com.vmware.nsx.fabric.VifsTypes {

    /**
     * Returns information about all VIFs. A virtual network interface aggregates
     * network interfaces into a logical interface unit that is indistinuishable from a
     * physical network interface.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostId Id of the host where this vif is located. (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param lportAttachmentId LPort Attachment Id of the virtual network interface. (optional)
     * @param ownerVmId External id of the virtual machine. (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vmId Internal identifier of the virtual machine. (optional)
     * @return com.vmware.nsx.model.VirtualNetworkInterfaceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VirtualNetworkInterfaceListResult list(java.lang.String cursor, java.lang.String hostId, java.lang.String includedFields, java.lang.String lportAttachmentId, java.lang.String ownerVmId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vmId);

    /**
     * Returns information about all VIFs. A virtual network interface aggregates
     * network interfaces into a logical interface unit that is indistinuishable from a
     * physical network interface.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostId Id of the host where this vif is located. (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param lportAttachmentId LPort Attachment Id of the virtual network interface. (optional)
     * @param ownerVmId External id of the virtual machine. (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vmId Internal identifier of the virtual machine. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VirtualNetworkInterfaceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VirtualNetworkInterfaceListResult list(java.lang.String cursor, java.lang.String hostId, java.lang.String includedFields, java.lang.String lportAttachmentId, java.lang.String ownerVmId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vmId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all VIFs. A virtual network interface aggregates
     * network interfaces into a logical interface unit that is indistinuishable from a
     * physical network interface.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VirtualNetworkInterfaceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostId Id of the host where this vif is located. (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param lportAttachmentId LPort Attachment Id of the virtual network interface. (optional)
     * @param ownerVmId External id of the virtual machine. (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vmId Internal identifier of the virtual machine. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String hostId, java.lang.String includedFields, java.lang.String lportAttachmentId, java.lang.String ownerVmId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vmId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VirtualNetworkInterfaceListResult> asyncCallback);

    /**
     * Returns information about all VIFs. A virtual network interface aggregates
     * network interfaces into a logical interface unit that is indistinuishable from a
     * physical network interface.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VirtualNetworkInterfaceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostId Id of the host where this vif is located. (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param lportAttachmentId LPort Attachment Id of the virtual network interface. (optional)
     * @param ownerVmId External id of the virtual machine. (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vmId Internal identifier of the virtual machine. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String hostId, java.lang.String includedFields, java.lang.String lportAttachmentId, java.lang.String ownerVmId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vmId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VirtualNetworkInterfaceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
