/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.fabric.
 * Used by client-side stubs.
 */

package com.vmware.nsx.fabric;

public interface VirtualMachines extends com.vmware.vapi.bindings.Service, com.vmware.nsx.fabric.VirtualMachinesTypes {

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param virtualMachineTagUpdate (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void addtags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param virtualMachineTagUpdate (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void addtags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param virtualMachineTagUpdate (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void addtags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param virtualMachineTagUpdate (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void addtags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all virtual machines. If you have not added NSX tags
     * on the VM or removed all the NSX tags that were earlier added to the VM, then
     * tags property is not returned in the API response.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display Name of the virtual machine (optional)
     * @param excludeVmType VM types to be excluded (optional)
     * @param externalId External id of the virtual machine (optional)
     * @param hostId Id of the host where this vif is located (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.VirtualMachineListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VirtualMachineListResult list(java.lang.String cursor, java.lang.String displayName, java.lang.String excludeVmType, java.lang.String externalId, java.lang.String hostId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all virtual machines. If you have not added NSX tags
     * on the VM or removed all the NSX tags that were earlier added to the VM, then
     * tags property is not returned in the API response.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display Name of the virtual machine (optional)
     * @param excludeVmType VM types to be excluded (optional)
     * @param externalId External id of the virtual machine (optional)
     * @param hostId Id of the host where this vif is located (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VirtualMachineListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VirtualMachineListResult list(java.lang.String cursor, java.lang.String displayName, java.lang.String excludeVmType, java.lang.String externalId, java.lang.String hostId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all virtual machines. If you have not added NSX tags
     * on the VM or removed all the NSX tags that were earlier added to the VM, then
     * tags property is not returned in the API response.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VirtualMachineListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display Name of the virtual machine (optional)
     * @param excludeVmType VM types to be excluded (optional)
     * @param externalId External id of the virtual machine (optional)
     * @param hostId Id of the host where this vif is located (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String displayName, java.lang.String excludeVmType, java.lang.String externalId, java.lang.String hostId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VirtualMachineListResult> asyncCallback);

    /**
     * Returns information about all virtual machines. If you have not added NSX tags
     * on the VM or removed all the NSX tags that were earlier added to the VM, then
     * tags property is not returned in the API response.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VirtualMachineListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName Display Name of the virtual machine (optional)
     * @param excludeVmType VM types to be excluded (optional)
     * @param externalId External id of the virtual machine (optional)
     * @param hostId Id of the host where this vif is located (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String displayName, java.lang.String excludeVmType, java.lang.String externalId, java.lang.String hostId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VirtualMachineListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param virtualMachineTagUpdate (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void removetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param virtualMachineTagUpdate (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void removetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param virtualMachineTagUpdate (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void removetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param virtualMachineTagUpdate (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void removetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param virtualMachineTagUpdate (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void updatetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param virtualMachineTagUpdate (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void updatetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param virtualMachineTagUpdate (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void updatetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Perform action on a specific virtual machine. External id of the virtual machine
     * needs to be provided in the request body. Some of the actions that can be
     * performed are update tags, add tags, remove tags. To add tags to existing list
     * of tag, use action parameter add_tags. To remove tags from existing list of tag,
     * use action parameter remove_tags. To replace existing tags with new tags, use
     * action parameter update_tags. To clear all tags, provide an empty list and
     * action parameter as update_tags. The vmw-async: True HTTP header cannot be used
     * with this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param virtualMachineTagUpdate (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void updatetags(com.vmware.nsx.model.VirtualMachineTagUpdate virtualMachineTagUpdate, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
