/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.fabric.
 * Used by client-side stubs.
 */

package com.vmware.nsx.fabric;

public interface VirtualSwitches extends com.vmware.vapi.bindings.Service, com.vmware.nsx.fabric.VirtualSwitchesTypes {

    /**
     * Returns information about all virtual switches based on the request parameters.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cmLocalId Local Id of the virtual switch (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Discovered node ID (optional)
     * @param displayName Display name of the virtual switch (optional)
     * @param externalId External id of the virtual switch (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param originId ID of the compute manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uuid UUID of the switch (optional)
     * @return com.vmware.nsx.model.VirtualSwitchListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VirtualSwitchListResult list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String originId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uuid);

    /**
     * Returns information about all virtual switches based on the request parameters.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cmLocalId Local Id of the virtual switch (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Discovered node ID (optional)
     * @param displayName Display name of the virtual switch (optional)
     * @param externalId External id of the virtual switch (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param originId ID of the compute manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uuid UUID of the switch (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VirtualSwitchListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VirtualSwitchListResult list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String originId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uuid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all virtual switches based on the request parameters.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VirtualSwitchListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cmLocalId Local Id of the virtual switch (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Discovered node ID (optional)
     * @param displayName Display name of the virtual switch (optional)
     * @param externalId External id of the virtual switch (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param originId ID of the compute manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uuid UUID of the switch (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String originId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uuid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VirtualSwitchListResult> asyncCallback);

    /**
     * Returns information about all virtual switches based on the request parameters.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VirtualSwitchListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cmLocalId Local Id of the virtual switch (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Discovered node ID (optional)
     * @param displayName Display name of the virtual switch (optional)
     * @param externalId External id of the virtual switch (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param originId ID of the compute manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uuid UUID of the switch (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String originId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uuid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VirtualSwitchListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
