
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.loadbalancer;

/**
 * {@link LoadbalancerFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.loadbalancer package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class LoadbalancerFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private LoadbalancerFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link LoadbalancerFactory} factory instance
     */
    public static LoadbalancerFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        LoadbalancerFactory instance = new LoadbalancerFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.ApplicationProfiles}
     */
    public com.vmware.nsx.loadbalancer.ApplicationProfiles applicationProfilesService() {
        return this.stubFactory.createStub(ApplicationProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.ClientSslProfiles}
     */
    public com.vmware.nsx.loadbalancer.ClientSslProfiles clientSslProfilesService() {
        return this.stubFactory.createStub(ClientSslProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.Monitors}
     */
    public com.vmware.nsx.loadbalancer.Monitors monitorsService() {
        return this.stubFactory.createStub(Monitors.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.NodeUsageSummary}
     */
    public com.vmware.nsx.loadbalancer.NodeUsageSummary nodeUsageSummaryService() {
        return this.stubFactory.createStub(NodeUsageSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.PersistenceProfiles}
     */
    public com.vmware.nsx.loadbalancer.PersistenceProfiles persistenceProfilesService() {
        return this.stubFactory.createStub(PersistenceProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.Pools}
     */
    public com.vmware.nsx.loadbalancer.Pools poolsService() {
        return this.stubFactory.createStub(Pools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.Rules}
     */
    public com.vmware.nsx.loadbalancer.Rules rulesService() {
        return this.stubFactory.createStub(Rules.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.ServerSslProfiles}
     */
    public com.vmware.nsx.loadbalancer.ServerSslProfiles serverSslProfilesService() {
        return this.stubFactory.createStub(ServerSslProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.Services}
     */
    public com.vmware.nsx.loadbalancer.Services servicesService() {
        return this.stubFactory.createStub(Services.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.UsagePerNode}
     */
    public com.vmware.nsx.loadbalancer.UsagePerNode usagePerNodeService() {
        return this.stubFactory.createStub(UsagePerNode.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.VirtualServers}
     */
    public com.vmware.nsx.loadbalancer.VirtualServers virtualServersService() {
        return this.stubFactory.createStub(VirtualServers.class, this.stubConfig);
    }

    public com.vmware.nsx.loadbalancer.services.ServicesFactory services() {
        return com.vmware.nsx.loadbalancer.services.ServicesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.loadbalancer.ssl.SslFactory ssl() {
        return com.vmware.nsx.loadbalancer.ssl.SslFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
