
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.loadbalancer.services;

/**
 * {@link ServicesFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.loadbalancer.services package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class ServicesFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private ServicesFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link ServicesFactory} factory instance
     */
    public static ServicesFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        ServicesFactory instance = new ServicesFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.services.DebugInfo}
     */
    public com.vmware.nsx.loadbalancer.services.DebugInfo debugInfoService() {
        return this.stubFactory.createStub(DebugInfo.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.services.Statistics}
     */
    public com.vmware.nsx.loadbalancer.services.Statistics statisticsService() {
        return this.stubFactory.createStub(Statistics.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.services.Status}
     */
    public com.vmware.nsx.loadbalancer.services.Status statusService() {
        return this.stubFactory.createStub(Status.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.loadbalancer.services.Usage}
     */
    public com.vmware.nsx.loadbalancer.services.Usage usageService() {
        return this.stubFactory.createStub(Usage.class, this.stubConfig);
    }

    public com.vmware.nsx.loadbalancer.services.pools.PoolsFactory pools() {
        return com.vmware.nsx.loadbalancer.services.pools.PoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.loadbalancer.services.virtual_servers.VirtualServersFactory virtualServers() {
        return com.vmware.nsx.loadbalancer.services.virtual_servers.VirtualServersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
