/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing;

public interface StaticRoutes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.StaticRoutesTypes {

    /**
     * Adds a new static route on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> POST
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param staticRoute (required)
     * @return com.vmware.nsx.model.StaticRoute
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRoute create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticRoute staticRoute);

    /**
     * Adds a new static route on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> POST
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param staticRoute (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticRoute
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRoute create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticRoute staticRoute, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new static route on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> POST
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRoute
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param staticRoute (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticRoute staticRoute, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRoute> asyncCallback);

    /**
     * Adds a new static route on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> POST
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRoute
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param staticRoute (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticRoute staticRoute, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRoute> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id);

    /**
     * Deletes a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a specific static routes on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @return com.vmware.nsx.model.StaticRoute
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRoute get(java.lang.String logicalRouterId, java.lang.String id);

    /**
     * Read a specific static routes on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticRoute
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRoute get(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a specific static routes on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRoute
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRoute> asyncCallback);

    /**
     * Read a specific static routes on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRoute
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRoute> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about configured static routes, including the network
     * address and next hops for each static route. <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.StaticRouteListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRouteListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about configured static routes, including the network
     * address and next hops for each static route. <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticRouteListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRouteListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about configured static routes, including the network
     * address and next hops for each static route. <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRouteListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRouteListResult> asyncCallback);

    /**
     * Returns information about configured static routes, including the network
     * address and next hops for each static route. <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRouteListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRouteListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param staticRoute (required)
     * @return com.vmware.nsx.model.StaticRoute
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRoute update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.StaticRoute staticRoute);

    /**
     * Update a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param staticRoute (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticRoute
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticRoute update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.StaticRoute staticRoute, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRoute
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param staticRoute (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.StaticRoute staticRoute, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRoute> asyncCallback);

    /**
     * Update a specific static route on the specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/<route-id> <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/static-routes/<route-id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticRoute
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param staticRoute (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.StaticRoute staticRoute, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticRoute> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
