/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Configuration of authentication and password policies for the NSX node
 */
public final class AuthenticationPolicyProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String HASH_ALGORITHM_SHA512 = "sha512";

    public static final java.lang.String HASH_ALGORITHM_SHA256 = "sha256";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long retryPrompt;

    private java.lang.Long digits;

    private java.lang.String hashAlgorithm;

    private java.lang.Long lowerChars;

    private java.lang.Long maxRepeats;

    private java.lang.Long maxSequence;

    private java.lang.Long maximumPasswordLength;

    private java.lang.Long minimumPasswordLength;

    private java.lang.Long minimumUniqueChars;

    private java.lang.Long passwordRemembrance;

    private java.lang.Long specialChars;

    private java.lang.Long upperChars;

    private java.lang.Long apiFailedAuthLockoutPeriod;

    private java.lang.Long apiFailedAuthResetPeriod;

    private java.lang.Long apiMaxAuthFailures;

    private java.lang.Long cliFailedAuthLockoutPeriod;

    private java.lang.Long cliMaxAuthFailures;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public AuthenticationPolicyProperties() {
    }

    protected AuthenticationPolicyProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * Prompt user at most N times before returning with error. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRetryPrompt() {
        return this.retryPrompt;
    }

    /**
     * Prompt user at most N times before returning with error. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param retryPrompt New value for the property.
     */
    public void setRetryPrompt(java.lang.Long retryPrompt) {
        this.retryPrompt = retryPrompt;
    }

    /**
     * Number of digits (0..9) expected in user password. 
     * <p>N < 0, to set minimum
     * credit for having digits in the new password, i.e. this is the minimum number of
     * digits that must be met for a new password.</p> 
     * <p>N > 0, to set maximum credit
     * for having digits in the new password, i.e. per occurrence of digit in password
     * will attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> digits.</p> 
     * <p>N = 0, policy
     * will be not applicable.</p> By default minimum 1 digit is required for a new
     * password. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDigits() {
        return this.digits;
    }

    /**
     * Number of digits (0..9) expected in user password. 
     * <p>N < 0, to set minimum
     * credit for having digits in the new password, i.e. this is the minimum number of
     * digits that must be met for a new password.</p> 
     * <p>N > 0, to set maximum credit
     * for having digits in the new password, i.e. per occurrence of digit in password
     * will attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> digits.</p> 
     * <p>N = 0, policy
     * will be not applicable.</p> By default minimum 1 digit is required for a new
     * password. format: int64
     *
     * @param digits New value for the property.
     */
    public void setDigits(java.lang.Long digits) {
        this.digits = digits;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.AuthenticationPolicyProperties#HASH_ALGORITHM_SHA512}</li>
     * <li> {@link
     * com.vmware.nsx.model.AuthenticationPolicyProperties#HASH_ALGORITHM_SHA256}</li>
     * </ul> Sets hash/cryptographic algorithm type for new passwords.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.AuthenticationPolicyProperties#HASH_ALGORITHM_SHA512}</li>
     * <li> {@link
     * com.vmware.nsx.model.AuthenticationPolicyProperties#HASH_ALGORITHM_SHA256}</li>
     * </ul> Sets hash/cryptographic algorithm type for new passwords.
     *
     * @param hashAlgorithm New value for the property.
     */
    public void setHashAlgorithm(java.lang.String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    /**
     * Number of lower case characters (a..z) expected in user password. 
     * <p>N < 0, to
     * set minimum credit for having lower case characters in the new password, i.e.
     * this is the minimum number of lower case characters that must be met for a new
     * password.</p> 
     * <p>N > 0, to set maximum credit for having lower case characters
     * in the new password, i.e. per occurrence of lower case character in password
     * will attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> lower case characters.</p>
     *
     * <p>N = 0, policy will be not applicable.</p> By default minimum 1 lower case
     * character is required for a new password. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLowerChars() {
        return this.lowerChars;
    }

    /**
     * Number of lower case characters (a..z) expected in user password. 
     * <p>N < 0, to
     * set minimum credit for having lower case characters in the new password, i.e.
     * this is the minimum number of lower case characters that must be met for a new
     * password.</p> 
     * <p>N > 0, to set maximum credit for having lower case characters
     * in the new password, i.e. per occurrence of lower case character in password
     * will attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> lower case characters.</p>
     *
     * <p>N = 0, policy will be not applicable.</p> By default minimum 1 lower case
     * character is required for a new password. format: int64
     *
     * @param lowerChars New value for the property.
     */
    public void setLowerChars(java.lang.Long lowerChars) {
        this.lowerChars = lowerChars;
    }

    /**
     * Reject passwords which contain more than N same consecutive characters, like aaa
     * or 7777. To disable the check, value should be set to 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRepeats() {
        return this.maxRepeats;
    }

    /**
     * Reject passwords which contain more than N same consecutive characters, like aaa
     * or 7777. To disable the check, value should be set to 0. format: int64
     *
     * @param maxRepeats New value for the property.
     */
    public void setMaxRepeats(java.lang.Long maxRepeats) {
        this.maxRepeats = maxRepeats;
    }

    /**
     * Reject passwords which contain more than N monotonic character sequences.
     * Monotonic sequences can be '12345' or 'fedcb'. To disable the check, value
     * should be set to 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxSequence() {
        return this.maxSequence;
    }

    /**
     * Reject passwords which contain more than N monotonic character sequences.
     * Monotonic sequences can be '12345' or 'fedcb'. To disable the check, value
     * should be set to 0. format: int64
     *
     * @param maxSequence New value for the property.
     */
    public void setMaxSequence(java.lang.Long maxSequence) {
        this.maxSequence = maxSequence;
    }

    /**
     * Maximum number of characters allowed in password; user can not set their
     * password of length greater than this parameter. By default maximum length of
     * password is 128 characters. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaximumPasswordLength() {
        return this.maximumPasswordLength;
    }

    /**
     * Maximum number of characters allowed in password; user can not set their
     * password of length greater than this parameter. By default maximum length of
     * password is 128 characters. format: int64
     *
     * @param maximumPasswordLength New value for the property.
     */
    public void setMaximumPasswordLength(java.lang.Long maximumPasswordLength) {
        this.maximumPasswordLength = maximumPasswordLength;
    }

    /**
     * Minimum number of characters expected in password; user can not set their
     * password of length less than this parameter.<br/> NOTE, for existing users
     * upgrading to NSX-T datacenter version 4.0 or above - 
     * <p>if existing appliance
     * is configured with <code>minimum_password_length</code> less than current
     * default value, then upgraded appliance will reset the configured setting back to
     * recommended default; which can be explicitly modified back to original value or
     * any other integer greater than or equal to supported minimum value.</p>
     *
     * <p>VMware recommends to set strong passwords for systems and appliances,
     * further suggests to maintain strong <code>minimum_password_length</code> value.
     * NSX resets this value to default and recommends to maintain upgraded default
     * value or above for password complexity requirement.</p> 
     * <p>If any existing user
     * passwords are set with length of less than newly configured
     * <code>minimum_password_length</code>, then its recommended to reset the user
     * passwords as per newly configured password complexity compliance.</p> 
     * <p>If
     * existing <code>minimum_password_length</code> is greater than or equal to
     * default value, which shall be retained as it is in newly upgraded appliance.</p>
     * By default minimum length of password is 12 characters and passwords less than 8
     * characters are never allowed. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    /**
     * Minimum number of characters expected in password; user can not set their
     * password of length less than this parameter.<br/> NOTE, for existing users
     * upgrading to NSX-T datacenter version 4.0 or above - 
     * <p>if existing appliance
     * is configured with <code>minimum_password_length</code> less than current
     * default value, then upgraded appliance will reset the configured setting back to
     * recommended default; which can be explicitly modified back to original value or
     * any other integer greater than or equal to supported minimum value.</p>
     *
     * <p>VMware recommends to set strong passwords for systems and appliances,
     * further suggests to maintain strong <code>minimum_password_length</code> value.
     * NSX resets this value to default and recommends to maintain upgraded default
     * value or above for password complexity requirement.</p> 
     * <p>If any existing user
     * passwords are set with length of less than newly configured
     * <code>minimum_password_length</code>, then its recommended to reset the user
     * passwords as per newly configured password complexity compliance.</p> 
     * <p>If
     * existing <code>minimum_password_length</code> is greater than or equal to
     * default value, which shall be retained as it is in newly upgraded appliance.</p>
     * By default minimum length of password is 12 characters and passwords less than 8
     * characters are never allowed. format: int64
     *
     * @param minimumPasswordLength New value for the property.
     */
    public void setMinimumPasswordLength(java.lang.Long minimumPasswordLength) {
        this.minimumPasswordLength = minimumPasswordLength;
    }

    /**
     * Number of character changes in the new password that differentiate it from the
     * old password. To disable the check, value should be set to 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinimumUniqueChars() {
        return this.minimumUniqueChars;
    }

    /**
     * Number of character changes in the new password that differentiate it from the
     * old password. To disable the check, value should be set to 0. format: int64
     *
     * @param minimumUniqueChars New value for the property.
     */
    public void setMinimumUniqueChars(java.lang.Long minimumUniqueChars) {
        this.minimumUniqueChars = minimumUniqueChars;
    }

    /**
     * Limit using a password that was used in past; users can not set the same
     * password within the N generations. To disable the check, value should be set to
     * 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPasswordRemembrance() {
        return this.passwordRemembrance;
    }

    /**
     * Limit using a password that was used in past; users can not set the same
     * password within the N generations. To disable the check, value should be set to
     * 0. format: int64
     *
     * @param passwordRemembrance New value for the property.
     */
    public void setPasswordRemembrance(java.lang.Long passwordRemembrance) {
        this.passwordRemembrance = passwordRemembrance;
    }

    /**
     * Number of special characters (!@#$&*..) expected in user password. 
     * <p>N < 0, to
     * set minimum credit for having special characters in the new password, i.e. this
     * is the minimum number of special characters that must be met for a new
     * password.</p> 
     * <p>N > 0, to set maximum credit for having special characters in
     * the new password, i.e. per occurrence of special case character in password will
     * attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> special case characters.</p>
     *
     * <p>N = 0, policy will be not applicable.</p> By default minimum 1 special
     * character is required for a new password. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpecialChars() {
        return this.specialChars;
    }

    /**
     * Number of special characters (!@#$&*..) expected in user password. 
     * <p>N < 0, to
     * set minimum credit for having special characters in the new password, i.e. this
     * is the minimum number of special characters that must be met for a new
     * password.</p> 
     * <p>N > 0, to set maximum credit for having special characters in
     * the new password, i.e. per occurrence of special case character in password will
     * attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> special case characters.</p>
     *
     * <p>N = 0, policy will be not applicable.</p> By default minimum 1 special
     * character is required for a new password. format: int64
     *
     * @param specialChars New value for the property.
     */
    public void setSpecialChars(java.lang.Long specialChars) {
        this.specialChars = specialChars;
    }

    /**
     * Number of upper case characters (A..Z) expected in user password. 
     * <p>N < 0, to
     * set minimum credit for having upper case characters in the new password, i.e.
     * this is the minimum number of lower case characters that must be met for a new
     * password.</p> 
     * <p>N > 0, to set maximum credit for having upper case characters
     * in the new password, i.e. per occurrence of upper case character in password
     * will attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> upper case characters.</p>
     *
     * <p>N = 0, policy will be not applicable.</p> By default minimum 1 upper case
     * character is required for a new password. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUpperChars() {
        return this.upperChars;
    }

    /**
     * Number of upper case characters (A..Z) expected in user password. 
     * <p>N < 0, to
     * set minimum credit for having upper case characters in the new password, i.e.
     * this is the minimum number of lower case characters that must be met for a new
     * password.</p> 
     * <p>N > 0, to set maximum credit for having upper case characters
     * in the new password, i.e. per occurrence of upper case character in password
     * will attribute additional credit of +1 towards meeting the current
     * <b>minimum_password_length</b> value upto <b>N</b> upper case characters.</p>
     *
     * <p>N = 0, policy will be not applicable.</p> By default minimum 1 upper case
     * character is required for a new password. format: int64
     *
     * @param upperChars New value for the property.
     */
    public void setUpperChars(java.lang.Long upperChars) {
        this.upperChars = upperChars;
    }

    /**
     * Once a lockout occurs, the account remains locked out of the API for this time
     * period. Only applies to NSX Manager nodes. Ignored on other node types. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getApiFailedAuthLockoutPeriod() {
        return this.apiFailedAuthLockoutPeriod;
    }

    /**
     * Once a lockout occurs, the account remains locked out of the API for this time
     * period. Only applies to NSX Manager nodes. Ignored on other node types. format:
     * int64
     *
     * @param apiFailedAuthLockoutPeriod New value for the property.
     */
    public void setApiFailedAuthLockoutPeriod(java.lang.Long apiFailedAuthLockoutPeriod) {
        this.apiFailedAuthLockoutPeriod = apiFailedAuthLockoutPeriod;
    }

    /**
     * In order to trigger an account lockout, all authentication failures must occur
     * in this time window. If the reset period expires, the failed login count is
     * reset to zero. Only applies to NSX Manager nodes. Ignored on other node types.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getApiFailedAuthResetPeriod() {
        return this.apiFailedAuthResetPeriod;
    }

    /**
     * In order to trigger an account lockout, all authentication failures must occur
     * in this time window. If the reset period expires, the failed login count is
     * reset to zero. Only applies to NSX Manager nodes. Ignored on other node types.
     * format: int64
     *
     * @param apiFailedAuthResetPeriod New value for the property.
     */
    public void setApiFailedAuthResetPeriod(java.lang.Long apiFailedAuthResetPeriod) {
        this.apiFailedAuthResetPeriod = apiFailedAuthResetPeriod;
    }

    /**
     * Only applies to NSX Manager nodes. Ignored on other node types. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getApiMaxAuthFailures() {
        return this.apiMaxAuthFailures;
    }

    /**
     * Only applies to NSX Manager nodes. Ignored on other node types. format: int64
     *
     * @param apiMaxAuthFailures New value for the property.
     */
    public void setApiMaxAuthFailures(java.lang.Long apiMaxAuthFailures) {
        this.apiMaxAuthFailures = apiMaxAuthFailures;
    }

    /**
     * Once a lockout occurs, the account remains locked out of the CLI for this time
     * period. While the lockout period is in effect, additional authentication
     * attempts restart the lockout period, even if a valid password is specified.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCliFailedAuthLockoutPeriod() {
        return this.cliFailedAuthLockoutPeriod;
    }

    /**
     * Once a lockout occurs, the account remains locked out of the CLI for this time
     * period. While the lockout period is in effect, additional authentication
     * attempts restart the lockout period, even if a valid password is specified.
     * format: int64
     *
     * @param cliFailedAuthLockoutPeriod New value for the property.
     */
    public void setCliFailedAuthLockoutPeriod(java.lang.Long cliFailedAuthLockoutPeriod) {
        this.cliFailedAuthLockoutPeriod = cliFailedAuthLockoutPeriod;
    }

    /**
     * Number of authentication failures that trigger CLI lockout format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCliMaxAuthFailures() {
        return this.cliMaxAuthFailures;
    }

    /**
     * Number of authentication failures that trigger CLI lockout format: int64
     *
     * @param cliMaxAuthFailures New value for the property.
     */
    public void setCliMaxAuthFailures(java.lang.Long cliMaxAuthFailures) {
        this.cliMaxAuthFailures = cliMaxAuthFailures;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.authenticationPolicyProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_retry_prompt",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.retryPrompt, this._getType().getField("_retry_prompt")));
        structValue.setField("digits",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.digits, this._getType().getField("digits")));
        structValue.setField("hash_algorithm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hashAlgorithm, this._getType().getField("hash_algorithm")));
        structValue.setField("lower_chars",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lowerChars, this._getType().getField("lower_chars")));
        structValue.setField("max_repeats",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRepeats, this._getType().getField("max_repeats")));
        structValue.setField("max_sequence",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxSequence, this._getType().getField("max_sequence")));
        structValue.setField("maximum_password_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maximumPasswordLength, this._getType().getField("maximum_password_length")));
        structValue.setField("minimum_password_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minimumPasswordLength, this._getType().getField("minimum_password_length")));
        structValue.setField("minimum_unique_chars",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minimumUniqueChars, this._getType().getField("minimum_unique_chars")));
        structValue.setField("password_remembrance",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.passwordRemembrance, this._getType().getField("password_remembrance")));
        structValue.setField("special_chars",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.specialChars, this._getType().getField("special_chars")));
        structValue.setField("upper_chars",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.upperChars, this._getType().getField("upper_chars")));
        structValue.setField("api_failed_auth_lockout_period",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.apiFailedAuthLockoutPeriod, this._getType().getField("api_failed_auth_lockout_period")));
        structValue.setField("api_failed_auth_reset_period",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.apiFailedAuthResetPeriod, this._getType().getField("api_failed_auth_reset_period")));
        structValue.setField("api_max_auth_failures",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.apiMaxAuthFailures, this._getType().getField("api_max_auth_failures")));
        structValue.setField("cli_failed_auth_lockout_period",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cliFailedAuthLockoutPeriod, this._getType().getField("cli_failed_auth_lockout_period")));
        structValue.setField("cli_max_auth_failures",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cliMaxAuthFailures, this._getType().getField("cli_max_auth_failures")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.authenticationPolicyProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.authenticationPolicyProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static AuthenticationPolicyProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new AuthenticationPolicyProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static AuthenticationPolicyProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new AuthenticationPolicyProperties(structValue);
    }

    /**
     * Builder class for {@link AuthenticationPolicyProperties}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long retryPrompt;
        private java.lang.Long digits;
        private java.lang.String hashAlgorithm;
        private java.lang.Long lowerChars;
        private java.lang.Long maxRepeats;
        private java.lang.Long maxSequence;
        private java.lang.Long maximumPasswordLength;
        private java.lang.Long minimumPasswordLength;
        private java.lang.Long minimumUniqueChars;
        private java.lang.Long passwordRemembrance;
        private java.lang.Long specialChars;
        private java.lang.Long upperChars;
        private java.lang.Long apiFailedAuthLockoutPeriod;
        private java.lang.Long apiFailedAuthResetPeriod;
        private java.lang.Long apiMaxAuthFailures;
        private java.lang.Long cliFailedAuthLockoutPeriod;
        private java.lang.Long cliMaxAuthFailures;

        /**
         * Constructor with parameters for the required properties of
         * {@link AuthenticationPolicyProperties}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * Prompt user at most N times before returning with error. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param retryPrompt New value for the property.
         */
        public Builder setRetryPrompt(java.lang.Long retryPrompt) {
            this.retryPrompt = retryPrompt;
            return this;
        }

        /**
         * Number of digits (0..9) expected in user password. 
         * <p>N < 0, to set minimum
         * credit for having digits in the new password, i.e. this is the minimum number of
         * digits that must be met for a new password.</p> 
         * <p>N > 0, to set maximum credit
         * for having digits in the new password, i.e. per occurrence of digit in password
         * will attribute additional credit of +1 towards meeting the current
         * <b>minimum_password_length</b> value upto <b>N</b> digits.</p> 
         * <p>N = 0, policy
         * will be not applicable.</p> By default minimum 1 digit is required for a new
         * password. format: int64
         *
         * @param digits New value for the property.
         */
        public Builder setDigits(java.lang.Long digits) {
            this.digits = digits;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.AuthenticationPolicyProperties#HASH_ALGORITHM_SHA512}</li>
         * <li> {@link
         * com.vmware.nsx.model.AuthenticationPolicyProperties#HASH_ALGORITHM_SHA256}</li>
         * </ul> Sets hash/cryptographic algorithm type for new passwords.
         *
         * @param hashAlgorithm New value for the property.
         */
        public Builder setHashAlgorithm(java.lang.String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        /**
         * Number of lower case characters (a..z) expected in user password. 
         * <p>N < 0, to
         * set minimum credit for having lower case characters in the new password, i.e.
         * this is the minimum number of lower case characters that must be met for a new
         * password.</p> 
         * <p>N > 0, to set maximum credit for having lower case characters
         * in the new password, i.e. per occurrence of lower case character in password
         * will attribute additional credit of +1 towards meeting the current
         * <b>minimum_password_length</b> value upto <b>N</b> lower case characters.</p>
         *
         * <p>N = 0, policy will be not applicable.</p> By default minimum 1 lower case
         * character is required for a new password. format: int64
         *
         * @param lowerChars New value for the property.
         */
        public Builder setLowerChars(java.lang.Long lowerChars) {
            this.lowerChars = lowerChars;
            return this;
        }

        /**
         * Reject passwords which contain more than N same consecutive characters, like aaa
         * or 7777. To disable the check, value should be set to 0. format: int64
         *
         * @param maxRepeats New value for the property.
         */
        public Builder setMaxRepeats(java.lang.Long maxRepeats) {
            this.maxRepeats = maxRepeats;
            return this;
        }

        /**
         * Reject passwords which contain more than N monotonic character sequences.
         * Monotonic sequences can be '12345' or 'fedcb'. To disable the check, value
         * should be set to 0. format: int64
         *
         * @param maxSequence New value for the property.
         */
        public Builder setMaxSequence(java.lang.Long maxSequence) {
            this.maxSequence = maxSequence;
            return this;
        }

        /**
         * Maximum number of characters allowed in password; user can not set their
         * password of length greater than this parameter. By default maximum length of
         * password is 128 characters. format: int64
         *
         * @param maximumPasswordLength New value for the property.
         */
        public Builder setMaximumPasswordLength(java.lang.Long maximumPasswordLength) {
            this.maximumPasswordLength = maximumPasswordLength;
            return this;
        }

        /**
         * Minimum number of characters expected in password; user can not set their
         * password of length less than this parameter.<br/> NOTE, for existing users
         * upgrading to NSX-T datacenter version 4.0 or above - 
         * <p>if existing appliance
         * is configured with <code>minimum_password_length</code> less than current
         * default value, then upgraded appliance will reset the configured setting back to
         * recommended default; which can be explicitly modified back to original value or
         * any other integer greater than or equal to supported minimum value.</p>
         *
         * <p>VMware recommends to set strong passwords for systems and appliances,
         * further suggests to maintain strong <code>minimum_password_length</code> value.
         * NSX resets this value to default and recommends to maintain upgraded default
         * value or above for password complexity requirement.</p> 
         * <p>If any existing user
         * passwords are set with length of less than newly configured
         * <code>minimum_password_length</code>, then its recommended to reset the user
         * passwords as per newly configured password complexity compliance.</p> 
         * <p>If
         * existing <code>minimum_password_length</code> is greater than or equal to
         * default value, which shall be retained as it is in newly upgraded appliance.</p>
         * By default minimum length of password is 12 characters and passwords less than 8
         * characters are never allowed. format: int64
         *
         * @param minimumPasswordLength New value for the property.
         */
        public Builder setMinimumPasswordLength(java.lang.Long minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
            return this;
        }

        /**
         * Number of character changes in the new password that differentiate it from the
         * old password. To disable the check, value should be set to 0. format: int64
         *
         * @param minimumUniqueChars New value for the property.
         */
        public Builder setMinimumUniqueChars(java.lang.Long minimumUniqueChars) {
            this.minimumUniqueChars = minimumUniqueChars;
            return this;
        }

        /**
         * Limit using a password that was used in past; users can not set the same
         * password within the N generations. To disable the check, value should be set to
         * 0. format: int64
         *
         * @param passwordRemembrance New value for the property.
         */
        public Builder setPasswordRemembrance(java.lang.Long passwordRemembrance) {
            this.passwordRemembrance = passwordRemembrance;
            return this;
        }

        /**
         * Number of special characters (!@#$&*..) expected in user password. 
         * <p>N < 0, to
         * set minimum credit for having special characters in the new password, i.e. this
         * is the minimum number of special characters that must be met for a new
         * password.</p> 
         * <p>N > 0, to set maximum credit for having special characters in
         * the new password, i.e. per occurrence of special case character in password will
         * attribute additional credit of +1 towards meeting the current
         * <b>minimum_password_length</b> value upto <b>N</b> special case characters.</p>
         *
         * <p>N = 0, policy will be not applicable.</p> By default minimum 1 special
         * character is required for a new password. format: int64
         *
         * @param specialChars New value for the property.
         */
        public Builder setSpecialChars(java.lang.Long specialChars) {
            this.specialChars = specialChars;
            return this;
        }

        /**
         * Number of upper case characters (A..Z) expected in user password. 
         * <p>N < 0, to
         * set minimum credit for having upper case characters in the new password, i.e.
         * this is the minimum number of lower case characters that must be met for a new
         * password.</p> 
         * <p>N > 0, to set maximum credit for having upper case characters
         * in the new password, i.e. per occurrence of upper case character in password
         * will attribute additional credit of +1 towards meeting the current
         * <b>minimum_password_length</b> value upto <b>N</b> upper case characters.</p>
         *
         * <p>N = 0, policy will be not applicable.</p> By default minimum 1 upper case
         * character is required for a new password. format: int64
         *
         * @param upperChars New value for the property.
         */
        public Builder setUpperChars(java.lang.Long upperChars) {
            this.upperChars = upperChars;
            return this;
        }

        /**
         * Once a lockout occurs, the account remains locked out of the API for this time
         * period. Only applies to NSX Manager nodes. Ignored on other node types. format:
         * int64
         *
         * @param apiFailedAuthLockoutPeriod New value for the property.
         */
        public Builder setApiFailedAuthLockoutPeriod(java.lang.Long apiFailedAuthLockoutPeriod) {
            this.apiFailedAuthLockoutPeriod = apiFailedAuthLockoutPeriod;
            return this;
        }

        /**
         * In order to trigger an account lockout, all authentication failures must occur
         * in this time window. If the reset period expires, the failed login count is
         * reset to zero. Only applies to NSX Manager nodes. Ignored on other node types.
         * format: int64
         *
         * @param apiFailedAuthResetPeriod New value for the property.
         */
        public Builder setApiFailedAuthResetPeriod(java.lang.Long apiFailedAuthResetPeriod) {
            this.apiFailedAuthResetPeriod = apiFailedAuthResetPeriod;
            return this;
        }

        /**
         * Only applies to NSX Manager nodes. Ignored on other node types. format: int64
         *
         * @param apiMaxAuthFailures New value for the property.
         */
        public Builder setApiMaxAuthFailures(java.lang.Long apiMaxAuthFailures) {
            this.apiMaxAuthFailures = apiMaxAuthFailures;
            return this;
        }

        /**
         * Once a lockout occurs, the account remains locked out of the CLI for this time
         * period. While the lockout period is in effect, additional authentication
         * attempts restart the lockout period, even if a valid password is specified.
         * format: int64
         *
         * @param cliFailedAuthLockoutPeriod New value for the property.
         */
        public Builder setCliFailedAuthLockoutPeriod(java.lang.Long cliFailedAuthLockoutPeriod) {
            this.cliFailedAuthLockoutPeriod = cliFailedAuthLockoutPeriod;
            return this;
        }

        /**
         * Number of authentication failures that trigger CLI lockout format: int64
         *
         * @param cliMaxAuthFailures New value for the property.
         */
        public Builder setCliMaxAuthFailures(java.lang.Long cliMaxAuthFailures) {
            this.cliMaxAuthFailures = cliMaxAuthFailures;
            return this;
        }

        public AuthenticationPolicyProperties build() {
            AuthenticationPolicyProperties result = new AuthenticationPolicyProperties();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRetryPrompt(this.retryPrompt);
            result.setDigits(this.digits);
            result.setHashAlgorithm(this.hashAlgorithm);
            result.setLowerChars(this.lowerChars);
            result.setMaxRepeats(this.maxRepeats);
            result.setMaxSequence(this.maxSequence);
            result.setMaximumPasswordLength(this.maximumPasswordLength);
            result.setMinimumPasswordLength(this.minimumPasswordLength);
            result.setMinimumUniqueChars(this.minimumUniqueChars);
            result.setPasswordRemembrance(this.passwordRemembrance);
            result.setSpecialChars(this.specialChars);
            result.setUpperChars(this.upperChars);
            result.setApiFailedAuthLockoutPeriod(this.apiFailedAuthLockoutPeriod);
            result.setApiFailedAuthResetPeriod(this.apiFailedAuthResetPeriod);
            result.setApiMaxAuthFailures(this.apiMaxAuthFailures);
            result.setCliFailedAuthLockoutPeriod(this.cliFailedAuthLockoutPeriod);
            result.setCliMaxAuthFailures(this.cliMaxAuthFailures);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_retry_prompt", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_retry_prompt",
                                                                                "retryPrompt",
                                                                                "getRetryPrompt",
                                                                                "setRetryPrompt");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("digits", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("digits",
                                                                                "digits",
                                                                                "getDigits",
                                                                                "setDigits");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hash_algorithm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hash_algorithm",
                                                                                "hashAlgorithm",
                                                                                "getHashAlgorithm",
                                                                                "setHashAlgorithm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lower_chars", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lower_chars",
                                                                                "lowerChars",
                                                                                "getLowerChars",
                                                                                "setLowerChars");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_repeats", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_repeats",
                                                                                "maxRepeats",
                                                                                "getMaxRepeats",
                                                                                "setMaxRepeats");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_sequence", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_sequence",
                                                                                "maxSequence",
                                                                                "getMaxSequence",
                                                                                "setMaxSequence");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("maximum_password_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("maximum_password_length",
                                                                                "maximumPasswordLength",
                                                                                "getMaximumPasswordLength",
                                                                                "setMaximumPasswordLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("minimum_password_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("minimum_password_length",
                                                                                "minimumPasswordLength",
                                                                                "getMinimumPasswordLength",
                                                                                "setMinimumPasswordLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("minimum_unique_chars", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("minimum_unique_chars",
                                                                                "minimumUniqueChars",
                                                                                "getMinimumUniqueChars",
                                                                                "setMinimumUniqueChars");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password_remembrance", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password_remembrance",
                                                                                "passwordRemembrance",
                                                                                "getPasswordRemembrance",
                                                                                "setPasswordRemembrance");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("special_chars", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("special_chars",
                                                                                "specialChars",
                                                                                "getSpecialChars",
                                                                                "setSpecialChars");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upper_chars", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("upper_chars",
                                                                                "upperChars",
                                                                                "getUpperChars",
                                                                                "setUpperChars");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("api_failed_auth_lockout_period", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("api_failed_auth_lockout_period",
                                                                                "apiFailedAuthLockoutPeriod",
                                                                                "getApiFailedAuthLockoutPeriod",
                                                                                "setApiFailedAuthLockoutPeriod");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("api_failed_auth_reset_period", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("api_failed_auth_reset_period",
                                                                                "apiFailedAuthResetPeriod",
                                                                                "getApiFailedAuthResetPeriod",
                                                                                "setApiFailedAuthResetPeriod");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("api_max_auth_failures", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("api_max_auth_failures",
                                                                                "apiMaxAuthFailures",
                                                                                "getApiMaxAuthFailures",
                                                                                "setApiMaxAuthFailures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cli_failed_auth_lockout_period", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cli_failed_auth_lockout_period",
                                                                                "cliFailedAuthLockoutPeriod",
                                                                                "getCliFailedAuthLockoutPeriod",
                                                                                "setCliFailedAuthLockoutPeriod");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cli_max_auth_failures", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cli_max_auth_failures",
                                                                                "cliMaxAuthFailures",
                                                                                "getCliMaxAuthFailures",
                                                                                "setCliMaxAuthFailures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.authentication_policy_properties",
                                                            fields,
                                                            com.vmware.nsx.model.AuthenticationPolicyProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

